/*
 * callback.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/X.h>
#include "util.h"

static HHOOK hDeliverEL;

static void NEAR PASCAL CainEnterNotify(HWND, int, int);
static void NEAR PASCAL CainLeaveNotify(HWND, int, int);

/* 
 * SendActivate	--
 *
 * callback function for EnumChildWindows 
 */

BOOL CALLBACK 
SendActivate(HWND hwnd, LPARAM lParam)	
{
    SendMessage(hwnd, WM_ACTIVATE,  0, 0L);
    return 1;
}

/* 
 * DeleteProperty
 * 
 * callback function for EnumProp 
 */

BOOL CALLBACK 
DeleteProperty(HWND hwnd, LPCSTR lpsz, HANDLE hData)	
{
    RemoveProp(hwnd, lpsz);
    GlobalFree(hData);
    return 1;
}

/* 
 * DeliverEnterLeave --
 * 
 * callback function for SetWindowsHookEx with WH_MOUSE 
 */

LRESULT CALLBACK 
DeliverEnterLeave(int code, WPARAM wParam, LPARAM lParam)
{
    MOUSEHOOKSTRUCT * lpmhs = (MOUSEHOOKSTRUCT *)lParam;
    POINT pt = lpmhs->pt;
    HWND hcurwnd = lpmhs->hwnd;
    HTASK mytask = GetCurrentTask();
    static HWND hprevwnd = 0;
    static int prev_x = 0;
    static int prev_y = 0;

    if (code < 0 || (wParam != WM_MOUSEMOVE && wParam != WM_NCMOUSEMOVE) ) 
    	goto nexthook;

    if (hprevwnd == hcurwnd) 
   	goto nexthook;

    if (GetWindowTask(hprevwnd) == mytask && hprevwnd != GetDesktopWindow()) {
    	if (GetWindowTask(hcurwnd) != mytask || hcurwnd == GetDesktopWindow()) {			
	    CainLeaveNotify(hprevwnd, prev_x, prev_y);
	} else {						
	    HWND hwnd1, hwnd2;

	    if (hprevwnd == hcurwnd) 
	   	goto nexthook;
   	   
	    for (hwnd1 = hcurwnd; hwnd1 != HWND_DESKTOP && hwnd1 != hprevwnd; 
	   	    hwnd1 = GetParent(hwnd1))
	   	;
   	   
	    for (hwnd2 = hprevwnd; hwnd2 != HWND_DESKTOP && hwnd2 != hcurwnd;
	   	    hwnd2 = GetParent(hwnd2))
	   	;

	    if (hwnd1 == HWND_DESKTOP && hwnd2 == HWND_DESKTOP) {
		CainEnterNotify(hcurwnd, pt.x, pt.y);
	    	CainLeaveNotify(hprevwnd, prev_x, prev_y);
            } else {
	   	if (hwnd1 == hprevwnd) {
		    CainEnterNotify(hcurwnd, pt.x, pt.y);
		} else {
		    CainLeaveNotify(hprevwnd, prev_x, prev_y);
		}
	    }
	}
    } else {
    	if (GetWindowTask(hcurwnd) == mytask) { 	    
	    CainEnterNotify(hcurwnd, pt.x, pt.y);
	}
    }

nexthook:
    hprevwnd = hcurwnd;
    prev_x = pt.x;
    prev_y = pt.y;

    return CallNextHookEx(hDeliverEL, code, wParam, lParam);
}

void FAR PASCAL
SetHookDeliverEL(HHOOK handle)
{
   hDeliverEL = handle;
}
 
static void NEAR PASCAL
CainEnterNotify(HWND hwnd, int x, int y)
{
    XEvent e;

    e.type = EnterNotify;
    e.xany.window = (Window) hwnd;
    e.xcrossing.x = x;
    e.xcrossing.y = y;
    e.xcrossing.detail = NotifyAncestor;
    e.xcrossing.mode = 0;	
    e.xcrossing.focus = 0;	
    e.xcrossing.state = 0;
    XPutBackEvent(XOpenDisplay(NULL), &e);
}

static void NEAR PASCAL
CainLeaveNotify(HWND hwnd, int x, int y)
{
    XEvent e;

    e.type = LeaveNotify;
    e.xany.window = (Window) hwnd;
    e.xcrossing.x = x;
    e.xcrossing.y = y;
    e.xcrossing.detail = NotifyInferior;
    e.xcrossing.mode = 0;
    e.xcrossing.focus = 0;
    e.xcrossing.state = 0;
    XPutBackEvent(XOpenDisplay(NULL), &e);
}









