/*
 * msg2evt.c -- v1.1
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h>
#ifdef KANJI
#include <mbctype.h>
#endif /* KANJI */
#include "wndproc.h"
#include "util.h"

int mbflag =0;
int negativegrab = 0;
int inputFlag  = 0;
extern int pointerGrabed;

void
__far __pascal
clearinputflag(void)
{
    inputFlag = 0;
}

static short int GetState(int flag)
{
    int state = 0;

    if (GetKeyState(VK_SHIFT) & 0x8000) state |= ShiftMask;
    if (GetKeyState(VK_CAPITAL) & 0x0001) state |= LockMask; 
    if (GetKeyState(VK_CONTROL) & 0x8000) state |= ControlMask; 
    if (GetKeyState(VK_NUMLOCK) & 0x0001) state |= Mod1Mask; 
/*    if (GetKeyState(VK_MENU) & 0x8000) state |= Mod2Mask; */
    if (GetKeyState(VK_SCROLL) & 0x0001)  state |= Mod3Mask; 
    if (flag) return (short) state;

    if (GetKeyState(VK_LBUTTON) & 0x8000) state |= Button1Mask;
    if (GetKeyState(VK_MBUTTON) & 0x8000) state |= Button3Mask; 
    if (GetKeyState(VK_RBUTTON) & 0x8000) state |= 
    (GetKeyState(VK_MENU) & 0x8000)?Button3Mask:Button2Mask;
    return (short) state;
}

int					
msg3event(Display *display, MSG *mPtr, XEvent *ePtr)
{
    RECT rc;
    POINT sPt;	
    DWORD dw;
    WINDOWPOS * pWndPos;

    ePtr->xany.window = (Window) mPtr->hwnd;
    ePtr->xany.serial = 0;
    ePtr->xany.send_event = False;
    ePtr->xany.display = display;
    switch(mPtr->message) {
    case INPUTNOTIFY :
	ePtr->type = InputNotify;
	ePtr->xany.window = (Window) mPtr->wParam;
	inputFlag = 1;
	break;
		
    case TIMERNOTIFY :
	ePtr->type = TimerNotify; 
	break;

    case ACTIVATEAPP:
    	ePtr->type = ActivateApp;
	break;
				 
    case CREATENOTIFY :
	ePtr->type = CreateNotify;
	ePtr->xcreatewindow.x = ((CREATESTRUCT FAR *)mPtr->lParam)->x;
	ePtr->xcreatewindow.y = ((CREATESTRUCT FAR *)mPtr->lParam)->y;
	ePtr->xcreatewindow.border_width = 1;
	ePtr->xcreatewindow.override_redirect = False;
	break;

    case DESTROYNOTIFY :
	ePtr->type = DestroyNotify;
	ePtr->xdestroywindow.event = ePtr->xdestroywindow.window = (Window) mPtr->wParam; 
	break;

    case WM_LBUTTONDOWN :
    case WM_MBUTTONDOWN :
    case WM_RBUTTONDOWN :
	ePtr->type = ButtonPress;		    
	if (GetCapture() == NULL) {
	    SetCapture(mPtr->hwnd);
	    negativegrab = 1;
	} 
	ePtr->xbutton.state = GetState(1);
	goto common_buttonevent;

    case WM_LBUTTONUP :
    case WM_MBUTTONUP :
    case WM_RBUTTONUP :
	ePtr->type = ButtonRelease;
	if (GetCapture() == mPtr->hwnd && negativegrab != 0) {
	    ReleaseCapture();
	    negativegrab = 0;
	}
	ePtr->xbutton.state = GetState(1);
    common_buttonevent:
	ePtr->xbutton.same_screen = True;
	ePtr->xbutton.time = mPtr->time;
	ePtr->xbutton.x = LOWORD(mPtr->lParam);
	ePtr->xbutton.y = HIWORD(mPtr->lParam);
	switch (mPtr->message) {
	case WM_LBUTTONUP :
	    ePtr->xbutton.state |= Button1Mask;
	case WM_LBUTTONDOWN:
	    ePtr->xbutton.button = Button1; 
	    break;	
	case WM_MBUTTONUP :
	    ePtr->xbutton.state |= Button3Mask;
	case WM_MBUTTONDOWN:
	    ePtr->xbutton.button = Button3; 
	    break;	
	case WM_RBUTTONUP :
	    ePtr->xbutton.state |= 
	    (GetKeyState(VK_MENU) & 0x8000) ? Button3Mask : Button2Mask;
	case WM_RBUTTONDOWN:
	    ePtr->xbutton.button = 
	    	    (GetKeyState(VK_MENU) & 0x8000)?Button3:Button2; 
	    break;	
	}

	ePtr->xbutton.state &= ~Mod1Mask;
	break;

    case WM_MOUSEMOVE :   			/* MotionNotify */
	ePtr->type = MotionNotify;
	ePtr->xmotion.window = ePtr->xmotion.subwindow = (Window) mPtr->hwnd;
	ePtr->xmotion.root = HWND_DESKTOP;	  
	ePtr->xmotion.time = mPtr->time;
	ePtr->xmotion.x = sPt.x = LOWORD(mPtr->lParam);
	ePtr->xmotion.y = sPt.y = HIWORD(mPtr->lParam);
	ClientToScreen(mPtr->hwnd, &sPt);
	ePtr->xmotion.x_root = sPt.x;
	ePtr->xmotion.y_root = sPt.y;
	ePtr->xmotion.state = GetState(0);
	break;
        
    case FOCUSIN :			/* FocusIn Event */
	ePtr->type = FocusIn;
	ePtr->xfocus.mode = NotifyNormal; 
	ePtr->xfocus.window = (Window) mPtr->hwnd; break;

    case FOCUSOUT :			/* FocusOut Event */
	ePtr->type = FocusIn;
	ePtr->xfocus.mode = NotifyNormal;
	ePtr->xfocus.window = (Window) mPtr->hwnd; break;

    case EXPOSE :				/* Expose Event */
	ePtr->type = Expose;
	ePtr->xexpose.count = 0;
	GetWindowRect(mPtr->hwnd, &rc);
	ePtr->xexpose.x = 0;
	ePtr->xexpose.y = 0;
	ePtr->xexpose.width = rc.right - rc.left;
	ePtr->xexpose.height = rc.bottom - rc.top;
	break;

    case WM_CHAR: 
#ifdef KANJI    
	if(mbflag == 0 && _ismbblead((unsigned short)mPtr->wParam)) {
    		ePtr->xany.flag = 0x1234;
		mbflag = 1;
	} else if(mbflag == 1 && _ismbbtrail((unsigned short)mPtr->wParam)) {
    		ePtr->xany.flag = 0x5678;
		mbflag = 0;
	} else {
		mbflag = 0;
    		ePtr->xany.flag = 0xABCD;
		
	}       
#else 	
	mbflag = 0;
	ePtr->xany.flag = 0xABCD;
#endif /* KANJI */

    case KEYPRESS :			/* KeyPress Event */
	ePtr->type = KeyPress;
	goto common_keyevent;

    case KEYRELEASE :				/* KeyRelease Event */
	ePtr->type = KeyRelease;
    common_keyevent:
	ePtr->xkey.window = ePtr->xkey.subwindow = (Window) mPtr->hwnd;		  
	ePtr->xkey.root = HWND_DESKTOP; 	
	ePtr->xkey.time = mPtr->time;
	dw = GetMessagePos();
	sPt = MAKEPOINT(dw);
	ePtr->xkey.x_root = sPt.x;
	ePtr->xkey.y_root = sPt.y;
	ScreenToClient(mPtr->hwnd, &sPt);
	ePtr->xkey.x = sPt.x;
	ePtr->xkey.y = sPt.y; 
	ePtr->xkey.keycode = mPtr->wParam;
	ePtr->xkey.state = GetState(0);
	break;

    case  MAPNOTIFY:			/* MapNotify, UnmapNotify Event */
	ePtr->type = MapNotify;
	goto common_mapevent;

    case UNMAPNOTIFY:
	ePtr->type = UnmapNotify;
    common_mapevent:
	ePtr->xmap.event = ePtr->xmap.window = (Window) mPtr->hwnd;		
	ePtr->xmap.override_redirect= False;
	break;

    case CONFIGURENOTIFY : 		/* ConfigureNotify, CirculateNotify Event */
	pWndPos = (WINDOWPOS *) GlobalLock((HGLOBAL) mPtr->wParam);
	ePtr->type = ConfigureNotify;
	ePtr->xconfigure.event = ePtr->xconfigure.window = (Window) mPtr->hwnd; 
	ePtr->xconfigure.x = pWndPos->x;
	ePtr->xconfigure.y = pWndPos->y;
	ePtr->xconfigure.width = pWndPos->cx;
	ePtr->xconfigure.height = pWndPos->cy;
	ePtr->xconfigure.border_width = 1;	
	ePtr->xconfigure.above = (Window) pWndPos->hwndInsertAfter;
	ePtr->xconfigure.override_redirect = False;
	GlobalUnlock((HGLOBAL) mPtr->wParam);
	GlobalFree((HGLOBAL) mPtr->wParam);
	break;

    case SELECTIONCLEAR:
    	ePtr->type = SelectionClear;
	ePtr->xselectionclear.window = (Window) mPtr->hwnd;
	ePtr->xselectionclear.selection = 0;
	ePtr->xselectionclear.serial = 1;
	break;

    case CLIENTMESSAGE:
    	ePtr->type = ClientMessage;
	ePtr->xany.window = (Window) mPtr->wParam;
	break;

    default :
	return 0;
    }
    return 1;
}
