/*
 * topproc.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h> 
#include <x11/xutil.h>
#include <string.h>
#include "wndproc.h"
#include "util.h"

extern int pointerGrabed;

/* 
 * XSetWindowAttributes
 */

XSetWindowAttributes defAttrs = {
    None,		/* backfround pixmap */ 
    RGB(255, 255, 255),	/* background pixel */
    None, 		/* border pixmap */	
    0L, 		/* border pixel */
    ForgetGravity, 	/* bit gravity */
    NorthWestGravity, 	/* window gravity */
    NotUseful,		/* backing store */
    0, 			/* backing planes */
    0, 			/* backing pixel */
    False, 		/* save under */
    0L, 		/* even tmask */
    0L, 		/* do not propagate mask */
    False, 		/* override redirect */
    None, 		/* colormap */
    None		/* cursor */
};

/* 
 * XWindowChanges
 */

XWindowChanges defChanges = {
    0, 		/* x */
    0, 		/* y */
    1, 		/* width */
    1, 		/* height */
    1, 		/* border width */
    None, 	/* sibling */
    Above	/* stack mode */
};

/* 
 *	RegisterTopLevelClass -- 
 *	
 *	
 */

void
__far __pascal 
RegisterTopLevelClass(HINSTANCE hInstance)
{
    WNDCLASS wndclass;

    wndclass.style	   = 0; /* CS_HREDRAW | CS_VREDRAW */
    wndclass.lpfnWndProc   = TopLevelProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 32;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon	   = LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor       = NULL;
    wndclass.hbrBackground = NULL;
    wndclass.lpszMenuName  = NULL;
    wndclass.lpszClassName = "TopLevel";

    RegisterClass(&wndclass);
}

/*
 *	TopLevelProc --
 *
 *
 */
 	
long FAR PASCAL
TopLevelProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    HDC hdc;
    PAINTSTRUCT pc;
    HGLOBAL hXSWAttrs, hXWChanges, hWork;
    XSetWindowAttributes * pXSWAttrs;
    XWindowChanges * pXWChanges;
    WINDOWPOS * pWndPos;
    HBRUSH hBrush;
    HCURSOR cs;

    switch(message) {
    case WM_CREATE:
	/* XSetWindowAttributes */
    	hXSWAttrs = GlobalAlloc(GHND, sizeof(XSetWindowAttributes));
	pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
	memcpy(pXSWAttrs, &defAttrs, sizeof(XSetWindowAttributes));
	GlobalUnlock(hXSWAttrs);
	/* XWindowChanges */
	hXWChanges = GlobalAlloc(GHND, sizeof(XWindowChanges));
	pXWChanges = (XWindowChanges *) GlobalLock(hXWChanges);
	memcpy(pXWChanges, &defChanges, sizeof(XWindowChanges));
	GlobalUnlock(hXWChanges);

    	SetWindowWord(hwnd, XSWA_OFFSET, (WORD) hXSWAttrs);
	SetWindowWord(hwnd, XWCH_OFFSET, (WORD) hXWChanges);
	PostMessage(hwnd, CREATENOTIFY,  wParam, lParam); 
	return 0;
  
    case WM_ACTIVATE:
	if (wParam != WA_INACTIVE) { 
    	    PostMessage(hwnd, EXPOSE, 0, 0L);

 	    EnumChildWindows(hwnd, MakeProcInstance(SendActivate, GetAppInstance()), 0L);
	}
	break;

    case WM_SETFOCUS:
	PostMessage(hwnd, FOCUSIN, wParam, lParam); 
	return 0;
	
    case WM_KILLFOCUS:
	PostMessage(hwnd, FOCUSOUT, wParam, lParam); 
	return 0;


    case WM_WINDOWPOSCHANGED:	 

    	hWork = GlobalAlloc(LHND, sizeof(WINDOWPOS));
	pWndPos = (WINDOWPOS *) GlobalLock(hWork);
	memcpy(pWndPos, (WINDOWPOS *)lParam, sizeof(WINDOWPOS));

	hXWChanges = GetWindowWord(hwnd, XWCH_OFFSET);
	pXWChanges = (XWindowChanges *) GlobalLock(hXWChanges);

    	hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
	pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
	if (pWndPos->flags & SWP_NOMOVE) {
	     pWndPos->x = pXWChanges->x;
	     pWndPos->y = pXWChanges->y;
	} else {
	     pXWChanges->x = pWndPos->x = ReAdjustX(pWndPos->x, pXSWAttrs->override_redirect);
	     pXWChanges->y = pWndPos->y = ReAdjustY(pWndPos->y, pXSWAttrs->override_redirect);
	}
	if (pWndPos->flags & SWP_NOSIZE) {
	     pWndPos->cx = pXWChanges->width;
	     pWndPos->cy = pXWChanges->height;
	} else {

	     pXWChanges->width = pWndPos->cx = ReAdjustWidth(pWndPos->cx, pXSWAttrs->override_redirect);
	     pXWChanges->height = pWndPos->cy = ReAdjustHeight(pWndPos->cy, pXSWAttrs->override_redirect);
	}
	GlobalUnlock(hWork);
	GlobalUnlock(hXWChanges);
	GlobalUnlock(hXSWAttrs);

	PostMessage(hwnd, CONFIGURENOTIFY, hWork, 0L); 

	break;

    case WM_GETMINMAXINFO:
    	if((hWork = GetProp(hwnd, "XA_WM_NORMAL_HINTS")) != NULL) {
	    XSizeHints * pHints;
	    MINMAXINFO FAR* lpmmi;

	    lpmmi = (MINMAXINFO FAR*) lParam;
	    pHints = (XSizeHints *) GlobalLock(hWork);

    	    hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
	    pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
	    if (!(pHints->flags & USSize)) {
	    	if (pHints->flags & PMinSize) {
	    	    lpmmi->ptMinTrackSize.x = 
	    	    	    AdjustWidth(pHints->min_width, pXSWAttrs->override_redirect);
		    lpmmi->ptMinTrackSize.y = 
			    AdjustHeight(pHints->min_height, pXSWAttrs->override_redirect);
	    	}
	    	if (pHints->flags & PMaxSize) {
	    	    lpmmi->ptMaxTrackSize.x = 
			    AdjustWidth(pHints->max_width, pXSWAttrs->override_redirect);
		    lpmmi->ptMaxTrackSize.y = 
			    AdjustHeight(pHints->max_height, pXSWAttrs->override_redirect);
	    	}
	    }
	    GlobalUnlock(hWork);
	    GlobalUnlock(hXSWAttrs);
	}
	break;

    case WM_SIZE:
    	switch (wParam) {
    	case SIZE_MINIMIZED:
	    hWork = GetProp(hwnd, "XA_WM_ICON_NAME"); break;
	case SIZE_MAXIMIZED:
	case SIZE_RESTORED: 
	    hWork = GetProp(hwnd, "XA_WM_NAME"); break;
	default:
	    hWork = NULL;
	}
	if (hWork != NULL) {
	    char * p;

	    p = (char *) GlobalLock(hWork);
	    SetWindowText(hwnd, p);
	    GlobalUnlock(hWork);
	}
	return 0;

    case WM_MOUSEMOVE: 
    	if ((cs = GetWindowWord(hwnd, HCCS_OFFSET)) == NULL) {
	    cs = FindCursor(hwnd);
	    SetWindowWord(hwnd, HCCS_OFFSET, (WORD) cs);
	}
	SetCursor(cs);				    
	return 0; 

    case WM_ACTIVATEAPP:
    	if (wParam == 0) {
	    PostMessage(hwnd, ACTIVATEAPP, 0, 0L);
	}
	return 0;

    case WM_NCLBUTTONUP:
    case WM_NCMBUTTONUP:
    case WM_NCRBUTTONUP:
    case WM_NCLBUTTONDOWN:
    case WM_NCMBUTTONDOWN:
    case WM_NCRBUTTONDOWN:
    case WM_NCLBUTTONDBLCLK:
    case WM_NCMBUTTONDBLCLK:
    case WM_NCRBUTTONDBLCLK:
    	if (pointerGrabed) {
	    return 0;
	}
	break;
	 
    case WM_CLOSE:
    	PostAppMessage(GetCurrentTask(), CLIENTMESSAGE, hwnd, 0L);
	return 0;

    case WM_DESTROY: 
    	GlobalFree(GetWindowWord(hwnd, XSWA_OFFSET));
	GlobalFree(GetWindowWord(hwnd, XWCH_OFFSET));
	EnumProps(hwnd, ClearProps);
	return 0;

    case WM_PAINT:
	hdc = BeginPaint(hwnd, &pc); 
	hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
    	pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
	hBrush = CreateSolidBrush(pXSWAttrs->background_pixel);
	GlobalUnlock(hXSWAttrs);
	FillRect(hdc, &pc.rcPaint, hBrush);
	DeleteObject(hBrush);
	EndPaint(hwnd, &pc);
	return 0;
    }
    DefWindowProc(hwnd, message, wParam, lParam);
}

			