/*
 * xallocsh.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h>
#include <x11/xutil.h>
#include <stdlib.h>
#include <string.h>
#include "util.h"

XSizeHints * FAR PASCAL
XAllocSizeHints(void)
{
    return (XSizeHints *) malloc(sizeof(XSizeHints));
}

/*
 * XSetWMNormalHints --
 *
 */

void FAR PASCAL
XSetWMNormalHints(Display *dummy, Window w, XSizeHints *hints)
{
    HGLOBAL hGlobal;
    XSizeHints * hPtr;

    if ((hGlobal = GetProp((HWND) w, "XA_WM_NORMAL_HINTS")) == NULL) {
    	hGlobal = GlobalAlloc(GHND, sizeof(XSizeHints));
    }
    hPtr = (XSizeHints *) GlobalLock(hGlobal);
    if (hPtr == NULL) {
	postError(BadAlloc, (HWND) w);	
	return;
    }
    memcpy(hPtr, hints, sizeof(XSizeHints));
    GlobalUnlock(hGlobal);
    SetProp((HWND) w, "XA_WM_NORMAL_HINTS", hGlobal);
}

/*
 * XSetWMHints --
 *
 */

void FAR PASCAL
XSetWMHints(Display *dummy, Window w, XWMHints *wmhints)
{
    HGLOBAL hGlobal;
    XWMHints * hPtr;

    if ((hGlobal = GetProp((HWND) w, "XA_WM_HINTS")) == NULL) {
    	hGlobal = GlobalAlloc(GHND, sizeof(XWMHints));
    }
    hPtr = (XWMHints *) GlobalLock(hGlobal);
    if (hPtr == NULL) {
	postError(BadAlloc, (HWND) w);	
	return;
    }
    memcpy(hPtr, wmhints, sizeof(XWMHints));
    GlobalUnlock(hGlobal);
    SetProp((HWND) w, "XA_WM_HINTS", hGlobal);
}

/*
 * XFree --
 *
 */
 	
void FAR PASCAL
XFree(char * ptr)
{
    free((void *)ptr);
}