/*
 * xclear.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include "wndproc.h"

void FAR PASCAL			 
XClearArea(Display * dummy1, Window w, int x, int y, 
	unsigned width, unsigned height, Bool dummy2)
{
    HWND hwnd = (HWND) w;
    HDC hdc = GetDC(hwnd);
    HGLOBAL hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
    XSetWindowAttributes * pXSWAttrs = (XSetWindowAttributes *) GlobalLock(hXSWAttrs);
    HBRUSH hbr = CreateSolidBrush(pXSWAttrs->background_pixel);
    HRGN hrgn = CreateRectRgn(x, y, x + width, y + height);
	
    FillRgn(hdc, hrgn, hbr);
    GlobalUnlock(hXSWAttrs);
    
    DeleteObject(hbr);
    DeleteObject(hrgn);
    ReleaseDC(hwnd, hdc);
}

void FAR PASCAL			
XClearWindow(Display * dummy, Window w)
{
    static RECT rc;

    HWND hwnd = (HWND) w;
    HDC hdc = GetDC(hwnd);
    HGLOBAL hXSWAttrs = GetWindowWord(hwnd, XSWA_OFFSET);
    XSetWindowAttributes * pXSWAttrs = (XSetWindowAttributes*) GlobalLock(hXSWAttrs);
    HBRUSH hbr = CreateSolidBrush(pXSWAttrs->background_pixel);
	
    GetWindowRect(hwnd, &rc);
    rc.right = rc.right - rc.left;
    rc.bottom = rc.bottom - rc.top;
    rc.left = 0;
    rc.top = 0;
    FillRect(hdc, &rc, hbr);
    GlobalUnlock(hXSWAttrs);
    
    DeleteObject(hbr);
    ReleaseDC(hwnd, hdc);
}