/*
 * xconfwin.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h>
#include "util.h"

/*
 * XConfigureWindow --
 *
 */

void FAR PASCAL
XConfigureWindow(Display *dummy, Window w, unsigned mask, 
	XWindowChanges *values)
{  
    unsigned char result;
    
    result = _SetWindowChanges(w, mask, values); 
    if (result != Success) 
    	postError(result, (HWND) w);
}

/*
 * XMoveWindow --
 *
 */

void FAR PASCAL
XMoveWindow(Display *dummy, Window w, int x, int y)
{
    XWindowChanges changes;
    unsigned char result;
     
    changes.x = x;
    changes.y = y;
    result = _SetWindowChanges(w, CWX|CWY,  &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void FAR PASCAL
XResizeWindow(Display *dummy, Window w, unsigned width, unsigned height)
{
    XWindowChanges changes;
    unsigned char result;

    changes.width = width;
    changes.height = height;
    result = _SetWindowChanges(w, CWWidth|CWHeight, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void FAR PASCAL
XMoveResizeWindow(Display *dummy, Window w, int x, int y, 
	unsigned width, unsigned height)
{
    XWindowChanges changes;
    unsigned char result;

    changes.x = x;
    changes.y = y;
    changes.width = width;
    changes.height = height;
    result = _SetWindowChanges(w, CWX|CWY|CWWidth|CWHeight, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void FAR PASCAL 
XSetWindowBorderWidth(Display *dummy, Window w, unsigned int width)
{
    XWindowChanges changes;
    unsigned char result;

    changes.border_width = width;
    result = _SetWindowChanges(w, CWBorderWidth, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}

void FAR PASCAL
XRaiseWindow(Display *dummy, Window w)
{
    XWindowChanges changes;
    unsigned char result;

    changes.sibling = None;
    changes.stack_mode = Above;
    result = _SetWindowChanges(w, CWSibling|CWStackMode, &changes);
    if (result != Success) 
    	postError(result, (HWND) w);
}