/*
 * xevent.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include <stdlib.h>
#include <string.h>
#include "wndproc.h"
#include "util.h"

#if 0
int FAR PASCAL	 
XCheckWindowEvent(display, w, mask, event)
Display *display;
Window w;
long mask;
XEvent *event;
{
    int type;
    _XQEvent *cPtr, *pPtr;

    XEventsQueued(display, 0);
    for(pPtr = NULL, cPtr = display->head; cPtr != NULL; 
    	    pPtr = cPtr, cPtr = cPtr->next) {
    	type = cPtr->event.type;
	if (type == MapNotify || type == UnmapNotify 
		|| type == ConfigureNotify || type == DestroyNotify) {
            peekEvent(cPtr, event);
	    if (pPtr != NULL)
	    	pPtr->next = discardEvent(cPtr);
	    else
	        display->head = discardEvent(cPtr);
	    return 1;
	}
    }
    return 0;
}	
#endif
     
int FAR PASCAL
XEventsQueued(Display *display, int mode)
{
    MSG msg;
    XEvent event;

    if (display->head != NULL && mode == 1)
	return 1;
    while (display->head == NULL || mode != 1) {
	if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE) == 0) {
	    return 0;
	}
	if( msg.hwnd == GetTbWindow() 
		|| (msg.message == WM_KEYDOWN 
			&& (msg.wParam == VK_NUMLOCK
				|| msg.wParam == VK_CAPITAL
				|| msg.wParam == VK_SCROLL)))
		TranslateMessage(&msg);
	DispatchMessage(&msg);
	if(msg3event(display, &msg, &event)) {
	    display->head = putEvent(&event, display->head);
	}
    }
    return 1;
}

void FAR PASCAL
XNextEvent(Display *display, XEvent *report)
{
    peekEvent(display->head, report);
    if ((display->head = discardEvent(display->head)) == NULL)
	display->tail = NULL;
}   

#if 0
Status FAR PASCAL
XSendEvent(display, w, propagate, event_mask, event_send)
	Display *display;
	Window w;
	Bool propagate;
	long event_mask;
	XEvent *event_send;
{
	XEvent e;
	memcpy( &e, event_send, sizeof(e) );
	e.xany.send_event = TRUE;
	display->head = putEvent( &e, display->head );
	return Success;
}
#endif

Bool FAR PASCAL
XCheckIfEvent(Display *display, XEvent *event_return, 	
	Bool (FAR PASCAL *predicate)( Display *, XEvent *, char * ),
	char *arg)
{
	_XQEvent *chain, *prev = NULL;
	for( chain = display->head; chain; prev=chain, chain=chain->next ) {
		if( !(*predicate)( display, &chain->event, arg ) )
			/* unmatch */
			continue;
		/* match, pick it up and discard */
		peekEvent( chain, event_return );
		chain = discardEvent(chain);
		if( prev ) prev->next = chain;
		return TRUE;
	}
	/* No match */
	return FALSE;
}

void FAR PASCAL
XPutBackEvent(Display *display, XEvent *event)
{
    _XQEvent *ePtr;
	
    if((ePtr = (_XQEvent *)malloc(sizeof(_XQEvent))) == NULL) {
 	return;
    }
    memcpy(&(ePtr->event), event, sizeof(XEvent));
    ePtr->next = display->head;
    display->head = ePtr;
}