/*
 * xgc.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include <stdlib.h>
#include "util.h"

/* 
 * 	XCreateGC -- 
 *
 */

GC	FAR PASCAL
XCreateGC(d, w, mask, values)
Display * d;		     
HWND w;
unsigned long mask;
XGCValues * values;
{
    GC gp;

    if (( gp = (XGCValues *)malloc(sizeof(XGCValues)) ) == None) 
	return None;

    gp->function = 	(mask & GCFunction) 	?values->function	:GXcopy;
    gp->plane_mask = 	(mask & GCPlaneMask) 	?values->plane_mask 	:~0;
    gp->foreground = 	(mask & GCForeground) 	?values->foreground 	:RGB(0, 0, 0);
    gp->background = 	(mask & GCBackground) 	?values->background 	:RGB(255, 255, 255);
    gp->line_width = 	(mask & GCLineWidth)	?values->line_width	:0;	
    gp->line_style = 	(mask & GCLineStyle)	?values->line_style	:LineSolid;
    gp->cap_style =  	(mask & GCCapStyle)	?values->cap_style	:0;
    gp->join_style = 	(mask & GCJoinStyle)	?values->join_style	:0;
    gp->fill_style =  	(mask & GCFillStyle)	?values->fill_style	:FillSolid;
    gp->fill_rule =  	(mask & GCFillRule)	?values->fill_rule	:WindingRule;
    gp->arc_mode = 	(mask & GCArcMode)	?values->arc_mode	:ArcPieSlice;
    gp->tile = 		(mask & GCTile)		?values->tile		:None;
    gp->stipple = 	(mask & GCStipple)	?values->stipple	:None;
    gp->ts_x_origin = 	(mask & GCTileStipXOrigin)	?values->ts_x_origin:0;
    gp->ts_y_origin = 	(mask & GCTileStipYOrigin)	?values->ts_y_origin:0;
    gp->font = 		(mask & GCFont)		?values->font		:None;
    gp->subwindow_mode = (mask & GCSubwindowMode)?values->subwindow_mode:ClipByChildren;
    gp->graphics_exposures = (mask & GCGraphicsExposures)?values->graphics_exposures:True;
    gp->clip_x_origin = (mask & GCClipXOrigin)	?values->clip_x_origin	:0;
    gp->clip_y_origin = (mask & GCClipYOrigin)	?values->clip_y_origin	:0;
    gp->clip_mask = 	(mask & GCClipMask)	?values->clip_mask	:None;
    gp->dash_offset = 	(mask & GCDashOffset)	?values->dash_offset	:0;
    gp->dashes = 	(mask & GCDashList)	?values->dashes		:4;

    return gp;
}  

/*
 * XFreeGC --
 *
 */

void FAR PASCAL
XFreeGC(d, gc)
Display _far * d;
GC gc;
{
    if (gc != None) free(gc);
}   


void FAR PASCAL 
XSetForeground(display, gc, foreground)
Display *display;
GC gc;
unsigned long foreground;
{
   gc->foreground = foreground;
}

void FAR PASCAL 
XSetBackground(display, gc, background)
Display *display;
GC gc;
unsigned long background;
{
   gc->background = background;
}

void FAR PASCAL
XSetFunction(display, gc, function)
Display *display;
GC gc;
int function;
{
    gc->function = function;
}

void FAR PASCAL
XSetFillRule(display, gc, fill_rule)
Display *display;
GC gc;
int fill_rule;
{
    gc->fill_rule = fill_rule;
}

void FAR PASCAL
XSetFillStyle(display, gc, fill_style)
Display *display;
GC gc;
int fill_style;
{
    gc->fill_style = fill_style;
}


void __far __pascal
XSetFont(display, gc, font)
Display *display;
GC gc;
HFONT font;
{
    gc->font = font;
}

void FAR PASCAL
XSetTSOrigin(display, gc, x, y)
Display *display;
GC gc;
int x, y;
{
    gc->ts_x_origin = x;
    gc->ts_y_origin = y;
}

void FAR PASCAL
XSetArcMode(display, gc, arc_mode)
Display *display;
GC gc;
int arc_mode;
{
    gc->arc_mode = arc_mode;
}

void FAR PASCAL
XSetStipple(display, gc, stipple)
Display *display;
GC gc;
Pixmap stipple;
{
    gc->stipple = stipple;
}


