/*
 * xpropert.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <x11/xlib.h>
#include <x11/xutil.h>
#include <stdlib.h>
#include <string.h>
#include "util.h"

FARPROC ClearProps;

static void	NEAR PASCAL	_ChangeProperty(Window, char *, char *, int);

Status FAR PASCAL
XStringListToTextProperty(list, n, ptp)
char **list;
int n;
XTextProperty *ptp;
{
    ptp->value = (unsigned char *)malloc(strlen(*list) + 1);
    strcpy(ptp->value, *list);
    return 1;
}

void FAR PASCAL
XSetWMName(d, w, ptp)
Display *d;
Window w;
XTextProperty *ptp;
{
    _ChangeProperty(w, "XA_WM_NAME", ptp->value, strlen(ptp->value)+1);
}

void FAR PASCAL
XSetIconName(d, w, p)
Display *d;
Window w;
const char *p;
{
    XTextProperty tp;
    
    XStringListToTextProperty((char **)&p, 1, &tp);
    _ChangeProperty(w, "XA_WM_ICON_NAME", tp.value, strlen(tp.value)+1);
    SendMessage(w, WM_SIZE, SIZE_MINIMIZED, 0L);
    XFree(tp.value);
}        	   

static void NEAR PASCAL
_ChangeProperty(w, np, dp, n)
Window w;
char *np, *dp;
int n;
{
    HGLOBAL hMem;
    char *p;
    if ((hMem = GetProp(w, np)) != NULL)
	GlobalFree(hMem);
    hMem = GlobalAlloc(GHND, n);
    p = (char *) GlobalLock(hMem);
    memcpy(p, dp, n);
    GlobalUnlock(hMem);
    SetProp(w, np, hMem);
}

void NEAR PASCAL
SetClearProps(HINSTANCE hInstance)
{
    ClearProps = MakeProcInstance(DeleteProperty, hInstance);
}		