/*
 * xwinattr.c --
 *
 * Copyright (c) 1994 Software Research Associates, Inc.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Software Research Associates not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  Software Research
 * Associates makes no representations about the suitability of this software
 * for any purpose.  It is provided "as is" without express or implied
 * warranty.
 */
 
#include <X11/Xlib.h>
#include "wndproc.h"
#include "util.h"

void FAR PASCAL
XChangeWindowAttributes(Display *dummy, Window w, unsigned long valuemask, 
	XSetWindowAttributes *attributes)
{
    unsigned char result;
    if ((result = _SetWindowAttributes(w, valuemask, attributes)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSetWindowBackground(Display *dummy, Window w, unsigned long background_pixel)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    attrs.background_pixel = background_pixel;
    if ((result = _SetWindowAttributes(w, CWBackPixel, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSetWindowBackgroundPixmap(Display *dummy, Window w, Pixmap background_pixmap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    attrs.background_pixmap = background_pixmap;
    if ((result = _SetWindowAttributes(w, CWBackPixmap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSetWindowBorder(Display *dummy, Window w, unsigned long border_pixel)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    attrs.border_pixel = border_pixel;
    if ((result = _SetWindowAttributes(w, CWBorderPixel, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSetWindowBorderPixmap(Display *dummy, Window w, Pixmap border_pixmap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    attrs.border_pixmap = border_pixmap;
    if ((result = _SetWindowAttributes(w, CWBorderPixmap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSetWindowColormap(Display *dummy, Window w, Colormap colormap)
{
    XSetWindowAttributes attrs;
    unsigned char result;
	
    attrs.colormap = colormap;
    if ((result = _SetWindowAttributes(w, CWColormap, &attrs)) != Success)
    	postError(result, (HWND) w);
}

void FAR PASCAL
XSelectInput(Display *dummy, Window w, long event_mask)
{
	XSetWindowAttributes attrs;

	attrs.event_mask = event_mask;
	_SetWindowAttributes(w, CWEventMask, &attrs);
}

