'\" 
'\" Copyright (c) 1994 Sun Microsystems, Inc. - All Rights Reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" software and its documentation for any purpose, provided that the
'\" above copyright notice and the following two paragraphs appear in
'\" all copies of this software.
'\" 
'\" IN NO EVENT SHALL SUN MICROSYSTEMS INC. BE LIABLE TO ANY PARTY FOR
'\" DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
'\" OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN MICROSYSTEMS
'\" INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" SUN MICROSYSTEMS INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS INC. HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
.so mttcl.macros
.HS mutex MTtcl
.BS
.SH NAME
mutex \- mutual exclusion locks
.SH SYNOPSIS
\fBmutex create\fR
.br
\fBmutex destroy \fImutex-id\fR
.br
\fBmutex lock \fImutex-id\fR
.br
\fBmutex unlock \fImutex-id\fR
.br
\fBmutex trylock \fImutex-id\fR
.BE
 
.SH DESCRIPTION
.PP
Mutual exclusion locks (mutexes) are used to serialize the execution
of Tcl threads.  They are typically used to ensure that only one
thread executes a critical section of code at any one time (mutual
exclusion).
.LP
Mutexes can be used to synchronize threads in this process and
other processes if they are allocated in memory that is writable
and shared among the cooperating processes (see \fBmmap\fR(2))
and have been created for this behavior.  This feature is not
directly available with MTtcl mutexes.
.LP
\fBmutex create\fR initializes a new mutex and returns its
\fImutex-id\fR.  The mutex can only be used in this process; type
is \fBUSYNC_THREAD\fR.
.LP
\fBmutex destroy\fR destroys the given mutex.
.LP
\fBmutex lock\fR locks the given mutex.  If the mutex is already locked,
the calling thread blocks until the mutex becomes available.  When
\fBmutex lock\fR returns, the mutex is locked and the calling thread
is the owner.
.LP
\fBmutex trylock\fR attempts to lock the given mutex.  If the mutex is
already locked it returns with an error.  Otherwise the mutex
is locked and the calling thread is the owner.
.LP
\fBmutex unlock\fR unlocks the given mutex.  The mutex must be locked
and the calling thread must be the one that last locked the mutex (the
owner).  If any other threads are waiting for the mutex to become
available, one of them is unblocked.
.SH MUTEX IDS
The \fImutex-ids\fR are formed by appending the memory address of
the mutex to the string ``mutex''.
.SH SEE ALSO
cond(n)
.SH BUGS
Using the memory address in the \fImutex-id\fR is a cheap hack
