'\" 
'\" Copyright (c) 1994 Sun Microsystems, Inc. - All Rights Reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" software and its documentation for any purpose, provided that the
'\" above copyright notice and the following two paragraphs appear in
'\" all copies of this software.
'\" 
'\" IN NO EVENT SHALL SUN MICROSYSTEMS INC. BE LIABLE TO ANY PARTY FOR
'\" DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
'\" OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN MICROSYSTEMS
'\" INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" SUN MICROSYSTEMS INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS INC. HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
.so mttcl.macros
.HS sema MTtcl
.BS
.SH NAME
sema \- semaphores
.SH SYNOPSIS
\fBsema create \fIcount\fR
.br
\fBsema destroy \fIsema-id\fR
.br
\fBsema wait \fIsema-id\fR
.br
\fBsema trywait \fIsema-id\fR
.br
\fBsema post \fIsema-id\fR
.BE
 
.SH DESCRIPTION
.PP
Conceptually, a semaphore is a non-negative integer count.
Semaphores are typically used to coordinate access to resources.
The semaphore count is initialized to the number of free resources.
Threads then atomically increment the count when resources are added
and atomically decrement the count when resources are removed.
When the semaphore count becomes zero, indicating no more resources are
present, threads trying to decrement the semaphore will block until
the count becomes greater than zero.
.LP
Semaphores can be used to synchronize threads in this process and
other processes if they are allocated in memory that is writable
and shared among the cooperating processes (see \fBmmap\fR(2))
and have been created for this behavior.  This feature is not
directly available with MTtcl semaphores.
.LP
\fBsema create\fR initializes a new semaphore with the given count
and returns its \fIsema-id\fR.  The semaphore can only be used in
this process; type is \fBUSYNC_THREAD\fR.
.LP
\fBsema destroy\fR destroys the given semaphore.
.LP
\fBsema wait\fR blocks the calling thread until the count in the 
given semaphore becomes greater than zero and then atomically
decrements it.
.LP
\fBmutex trywait\fR atomically decrements the count in the given
semaphore if the count is greater than zero.
Otherwise it returns an error.
.LP
\fBmutex post\fR atomically increments the count of the given
semaphore.  If there are any threads blocked on the semaphore, one
is unblocked.
.SH SEMAPHORE IDS
The \fIsema-ids\fR are formed by appending the memory address of
the semephore to the string ``sema''.
.SH BUGS
Using the memory address in the \fIsema-id\fR is a cheap hack
