'\" 
'\" Copyright (c) 1994 Sun Microsystems, Inc. - All Rights Reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" software and its documentation for any purpose, provided that the
'\" above copyright notice and the following two paragraphs appear in
'\" all copies of this software.
'\" 
'\" IN NO EVENT SHALL SUN MICROSYSTEMS INC. BE LIABLE TO ANY PARTY FOR
'\" DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
'\" OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF SUN MICROSYSTEMS
'\" INC. HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" SUN MICROSYSTEMS INC. SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND SUN MICROSYSTEMS INC. HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\"
.so mttcl.macros
.HS thread MTtcl
.BS
.SH NAME
'\" foo
thread \- Create and control Tcl threads
.SH SYNOPSIS
\fBthread \fIoption arg \fR?\fIarg ...?\fR
.BE

.SH DESCRIPTION
.PP
The \fBthread\fR command provides multi-thread features for
Tcl programs.  Each Tcl thread consists of a Tcl interpretter,
a script, and a thread to run the script.  Data and code must
be explicitly shared between Tcl threads (see \fBshare(n)\fR).
.LP
Although Tcl threads do not share the same features as are
available in other languages, they do provide all the benefits
(and pitfalls) of a fully threaded system.  Threads may be created,
joined, suspended, and continued.  In addition Tcl threads may
be named, listed, queried, and posted to.
.LP
Finally, the \fBthread\fR command is an interface to the Solaris 2 threads
package.  Virtually all functions documented in man page section 3t
are available.
.LP
The Tcl threads extension should be used with a Tcl interpretter
which has been modified for MT-safety.  Access to global and
static variables in the interpretter must be synchronized
across the Tcl threads.  This work has been done and is available
as MT-sturdy Tcl in the MTtcl package.  You should have received
MT-sturdy Tcl along with the Tcl threads extension.
.SH THREAD IDS
The \fIthread-ids\fR of Tcl threads follow the format \fBthread\fIN\fR where
\fIN\fR is the number assigned by the thread library.  Any where a
command takes a \fIthread-id\fR, the string /fBself/fR can be specified
to refer to the calling thread.
.br
The first thread to initialize the Tcl threads extension is given a
Tcl thread.  This thread will appear in the \fBthread list\fR command.
.SH THREAD CREATION
.in \n(INu
\fBthread create \fR?\fB-suspended\fR? ?\fB-detached\fR? ?\fB-bound\fR? \
?\fB-daemon\fR? ?\fB-new_lwp\fR? ?\fB-name name\fR? \
\fIscript\fR ?\fIarg arg ...\fR?
.in \n(INu+\n()Iu
Create a Tcl thread to run the given script.  See \fBthr_create\fR(3t)
for an explanation of the flags.  The \fB-name\fR flag assigns a name
to the new thread.  Any arguments following the script are used to set
the \fBargv\fR and \fBargc\fR variable in the new script.
.LP
The new thread has all the Tcl built-in commands plus the MTtcl
commands.  Extensions must be explicity initialized for each
Tcl thread.  This involves setting a callback function with
\fBMTtcl_SetThreadInitFunc(\|)\fR.  This callback will be invoked
just before each new thread is created.  The function should
use \fBTcl_CreateCommand\fR to add its commands to the interpretter.
\fBNOTE: \fRExtensions \fImust\fR
be compiled with \fB-D_REENTRANT\fR or they will not
work on any thread but the main thread.  In addition they need to be
MT-safe.
.SH THREAD CONTROL
.TP
\fBthread join \fR?\fB-result \fIvariable\fR? ?\fIthread-id\fR?
Blocks the calling thread until the given thread terminates.  The
thread must not be detached (\fBthread create -detached\fR).  If
no \fIthread-id\fR is specified, then the termination of any
undetached thread will unblock \fBthread join\fR.
.br
If \fB-result\fR is specified, the result of the Tcl thread is placed
in the variable.  Multiple threads cannot wait for the same thread to
terminate; one thread will return successfully and the others will
fail with an error.
.br
The thread-id of the departed thread is returned.
.TP
\fBthread suspend \fIthread-id\fR
Immediately suspends the execution of the given thread.  The suspended
thread is no longer executing after \fBthread suspend\fR returns.
.TP
\fBthread continue \fIthread-id\fR
Resumes the execution of a suspended thread.
.TP
\fBthread yield\fR
Causes the current thread to yield its execution in favor of another
thread with the same or greater priority.
.TP
\fBthread sleep \fIseconds \fR?\fInano-seconds\fR?
Causes the calling thread to sleep for at least the specified
amount of time.  There seems to be a minimum sleep time of 10
milliseconds.
.TP
\fBthread setprio \fIthread-id new-priority\fR 
Changes the priority of the given thread.
.br
Each thread has a priority which it inherits from its creator.  By default,
threads are scheduled based on fixed priorities that range from zero,
the least significant, to the largest integer.  The given thread will
preempt lower priority threads, and will yield to higher priority threas.
.TP
\fBthread getprio \fIthread-id\fR
Returns the current priority of the given thread.
.TP
\fBthread exit \fR?\fIresult\fR?
Terminates the calling thread.  If the thread is not detached, then the
thread-id and \fIresult\fR are returned with a subsequent
\fBthread join\fR.
.br
If the calling thread is the last non-daemon thread in the process, then
the process terminates with a status of zero.  If the initial thread
returns from \fImain\fR() then the process exits with a status equal to the
return value.
.SH THREAD INFORMATION
.TP
\fBthread self\fR
Return the thread-id of the current thread.
.TP
\fBthread list\fR
List the Tcl threads in the process.  Each thread is described by a
four element list.  Index 0 is the thread-id, index 1 is the thread
name, index 2 is the thread status, and index 3 is the thread result.
Status will be one of running, suspended, done, error, return,
break, continue, collision, or unknown.  The thread result is only
set after script evaluation is complete.
.TP
\fBthread name \fIthread-id\fR ?\fInew name\fR?
Return or set the name of the current thread.
.TP
\fBthread script \fIthread-id\fR
Return the script the thread is evaluating.
.TP
\fBthread status \fIthread-id\fR
Return the current status of the thread.  See \fBthread list\fR for
possible values.
.TP
\fBthread result \fIthread-id\fR
Return the current result of the thread.  The result is set after
a thread has completed script evaluations
.TP
\fBthread errorInfo \fIthread-id\fR
Return the value of the \fBerrorInfo\fR variable from the thread.
Can only be called after the thread has evaluated its script.
.TP
\fBthread errorCode \fIthread-id\fR
Return the value of the \fBerrorCode\fR variable from the thread.
Can only be called after the thread has evaluated its script.
.SH THREAD MESSAGING
.TP
\fBthread post \fIthread-id message\fR
Place a message in the given thread's message queue.
.TP
\fBthread nextmsg\fR
Returns the next message on the current thread's message queue.  If
the queue is empty, \fBthread nextmsg\fR blocks until a message is
enqueued by \fBthread post\fR.
.SH SEE ALSO
share(n), MTtcl_SetThreadInitFunc(?)
.SH BUGS
Thread list should list all threads or only given threads
.sp
There's no way to get a thread by name
.sp
There's no synchronous messaging
.sp
The Tcl thread library cannot be dynamically loaded by a program
that wasn't compiled with \fB-D_REENTRANT\fR.  This is bug in
Solaris 2.
