/*
 * This sample program reads input from the terminal, sends it to Natural Language,
 * and prints the results.
 */

#include "nlc.h"
#include "nlc_error.h"
#include <stdio.h>
#include <signal.h>

void		inthandler();
Nl_session	nlc;		/* Natural Language session handle */

main(argc,argv)
int	argc;
char	*argv[];
{
	Nl_status	status;		/* NLCLIB return code */
	char		line[256];	/* Input/output buffer */
	char		*command, *type;

	/*
	 * Start Natural Language and load the "sales" demo database connection.
	 */
	if (argc>1)
		command = argv[1];
	else
		command = "swan demo sales";
	nlc = nl_connect(command, "");
	if (nlc == NULL) {
		printf("Can't open Natural Language session\n");
		exit();
		}
	printf("Connected to Natural Language\n");

	/*
	 * Set up interrupt handler.
	 */
	signal(SIGINT, inthandler);

	while(1) {
		/*
		 * Read a line from the standard input.  Exit if end-of-file
		 * detected.
		 */
		printf("\nQuestion: ");
		fflush(stdout);
		gets(line);
		if (feof(stdin))
			break;

		/*
		 * Send the line to Natural Language.
		 */
		if (nl_ask(nlc, line) == NL_FAIL) {
			/*
			 * Error code is set to NLE_INTERRUPTED if nl_break
			 * was called.
			 */
			if(nl_get(nlc, NL_ERROR_CODE) != NLE_INTERRUPTED)
				break;
			}
		
		/*
		 * Get the results.  Loop for each text paragraph.  The return
		 * value NL_NO_MORE from nl_open() means that the entire answer has
		 * been returned.  The return value NL_NEED_REPLY means that
		 * additional information from the user is necessary in order to
		 * answer the question.
		 */
		while ((status = nl_open(nlc, NL_TEXT)) != NL_NO_MORE) {

			if (status == NL_FAIL)
				/*
				 * NL_FAIL could be returned if nl_break was called.
				 */
				continue;
			
			if (status == NL_NEED_REPLY) {

				/* Get response from user and send to Natural Language
				 * The prompt will have been printed in the previous
				 * text paragraph */
				gets(line);
				nl_reply(nlc, line);
				continue;
				}

			/* Get the paragraph type and display it. */
			switch (nl_get(nlc, NL_RESPONSE_TYPE)) {
			      case NL_TEXT:
				type = "Text";
				break;
			      case NL_ECHO:
				type = "Echo";
				break;
			      case NL_ANSWER:
				type = "Answer";
				break;
			      case NL_TABLE:
				type = "Table";
				break;
			      case NL_PROMPT:
				type = "Prompt";
				break;
			      case NL_ERROR_MESSAGE:
				type = "Error";
				break;
				}
			printf("\n%s:\n", type);

			/* Get the paragraph text and display it. */
			while (nl_fetch(nlc, NL_TEXT, line, sizeof line, NULL) == NL_SUCCESS)
				printf("%s\n", line);
			}
		}
	
	/* Finished.  Exit from Natural Language. */
	nl_exit(nlc);
}

void inthandler()
{
	/*
	 * Interrupt Natural Language.
	 */
	nl_break(nlc);
	return;
}
