/*
 * This sample program reads input from the terminal,
 * sends it to Natural Language, and prints the results.
 */

/*
 * compiled with:
 *cc -I/u/sybase/swan/include -o tabledata -L/u/sybase/swan/lib tabledata.c -lnlc
 */

#include "nlc.h"
#include "nlc_error.h"
#include <stdio.h>
#include <signal.h>

void		inthandler();
Nl_session	nlc;		/* Natural Language session handle */

main(argc,argv)
int	argc;
char	*argv[];
{
Nl_status	status, status2;	/* NLCLIB return code */
char		line[256];		/* Input/output buffer */
char		*command, *type;
int             nrt, nrt2;		/* nl response type */
int		i, nt, ncols, nrows, datatype, userexit;
unsigned	data;

/*
 * Start Natural Language and load the "sales" demo database connection.
 */
if (argc>1)
	command = argv[1];
else
	command = "swan -nt debug sales";
nlc = nl_connect(command, "");
if (nlc == NULL) {
	printf("Can't open Natural Language session\n");
	exit();
	}
printf("Connected to Natural Language\n");

/*
 * Set up interrupt handler.
 */
signal(SIGINT, inthandler);

printf("\nEnter 'y' for Text-Only Mode: ");
fflush(stdout);
gets(line);
if (strcmp(line, "y") && strcmp(line, "yes")) {
    /* turn off ascii table, turn on binary table */
    nl_set(nlc, NL_RESPONSE_MODE, NL_TABLE, 0);
    nl_set(nlc, NL_RESPONSE_MODE, NL_TABLE_DATA, 1);
    }
/*
nl_set(nlc, NL_RESPONSE_MODE, NL_ECHO, 0);
*/


userexit = 0;
while(1) {
	if (userexit) break;
	/*
	 * Read a line from the standard input.  Exit if end-of-file
	 * detected.
	 */
	printf("\nQuestion: ");
	fflush(stdout);
	gets(line);
	if (feof(stdin))
		break;

	/*
	 * Send the line to Natural Language.
	 */
	status = nl_ask(nlc, line);
	printf("nl_ask status: %d\n", status);
	if (status == NL_FAIL) {
		/*
		 * Error code is set to NLE_INTERRUPTED if nl_break
		 * was called.
		 */
		if(nl_get(nlc, NL_ERROR_CODE) != NLE_INTERRUPTED)
			break;
		}
	
	/*
	 * Get the results.  Loop for each text paragraph.  The return
	 * value NL_NO_MORE from nl_open() means that the entire answer has
	 * been returned.  The return value NL_NEED_REPLY means that
	 * additional information from the user is necessary in order to
	 * answer the question.
	 */
	while ((status = nl_open(nlc, NL_TEXT)) != NL_NO_MORE) {

		printf("\nnl_open status: %d\n", status);
		if (status == NL_FAIL) {
			if(nl_get(nlc, NL_ERROR_CODE) == NLE_USEREXIT)
				userexit = 1;
			/*
			 * NL_FAIL could be returned if nl_break was called.
			 */
			continue;
			}
		
		if (status == NL_NEED_REPLY) {

			/* Get response from user and send to Natural Language
			 * The prompt will have been printed in the previous
			 * text paragraph */
			gets(line);
			nl_reply(nlc, line);
			continue;
			}

		/* Get the paragraph type and display it. */
		switch (nrt = nl_get(nlc, NL_RESPONSE_TYPE)) {
		      case NL_TEXT:
			type = "Text";
			break;
		      case NL_ECHO:
			type = "Echo";
			break;
		      case NL_ANSWER:
			type = "Answer";
			break;
		      case NL_TABLE:
			type = "Table";
			break;
		      case NL_PROMPT:
			type = "Prompt";
			break;
		      case NL_ERROR_MESSAGE:
			type = "Error";
			break;
		      default:
			type = "Other";
			break;
			}
		printf("\n%s (%d):\n", type, nrt);

		/* Get the paragraph text and display it. */
		while ((status = nl_fetch(nlc, NL_TEXT, line, sizeof line,
                              NULL)) == NL_SUCCESS)
			printf("%s\n", line);
                printf("last fetch status: %d\n", status);
		}

printf("\nEnter 'y' for TableData: ");
fflush(stdout);
gets(line);
if (!strcmp(line, "y") || !strcmp(line, "yes")) {
    nt = nl_get(nlc, NL_TABLE_COUNT);
    printf("Tables (%d)\n", nt);

    while ((status = nl_open(nlc, NL_TABLE_DATA)) != NL_NO_MORE) {

	printf("\nTableData Status (%d)\n", status);
	if (status == NL_SUCCESS) {
	nrt = nl_get(nlc, NL_RESPONSE_TYPE);
	printf("TableData Response Type (%d)\n", nrt);

	nrows = 0;
	while (nl_fetchrow(nlc) == NL_SUCCESS) {

          /* print headers before the first row */
          if (nrows == 0) {
          ncols = nl_get(nlc, NL_COLUMN_COUNT);
	  printf("Columns (%d)\n", ncols);
          for (i=1; i<=ncols; i++)
            printf("%s  ", (char *)nl_get(nlc, NL_COLUMN_HEADER, i));
          printf("\n----------\n");
          } /* endif */

          /* print row data */
          for (i=1; i<=ncols; i++) {
            if (nl_get(nlc, NL_COLUMN_NULL, i) != 0) {
              printf("___  ");
              }
            else {
              datatype = nl_get(nlc, NL_COLUMN_TYPE, i);
              data = nl_get(nlc, NL_COLUMN_DATA, i);
              switch (datatype) {
                case NLCOL_INT:
                  printf("%d  ", *(int *)data);
                  break;
                case NLCOL_FLOAT:
                  printf("%g  ", *(double *)data);
                  break;
                case NLCOL_CHAR:
                  printf("%s  ", (char *)data);
                  break;
                case NLCOL_DATE:
                  nl_datechar((Nl_datetime *)data, line, sizeof(line), 0);
                  printf("%s  ", line);
                  break;
	        default:
                  printf("Unknown datatype (%d)  ");
		  break;
              } /* end switch */
            } /* endif */
          } /* endfor */
          printf("\n");

          nrows++;
          }
	printf("----------\nfetched %d row(s)\n", nrows);
	} /* endif NL_SUCCESS */
    } /* end while */
} /* endif tabledata? */

printf("\nEnter 'y' for Query: ");
fflush(stdout);
gets(line);
if (!strcmp(line, "y") || !strcmp(line, "yes")) {

    while ((status = nl_open(nlc, NL_QUERY)) != NL_NO_MORE) {

	printf("\nQuery Status (%d)\n", status);
	if (status == NL_SUCCESS) {
	nrt = nl_get(nlc, NL_RESPONSE_TYPE);
	printf("Query Response Type (%d)\n", nrt);
	while (nl_fetch(nlc, NL_QUERY, line, sizeof line, NULL) == NL_SUCCESS)
		printf("%s\n", line);
	} /* endif NL_SUCCESS */
    } /* end while */
} /* endif query? */

    } /* end outer while loop */

/* Finished.  Exit from Natural Language. */
nl_exit(nlc);
}

void inthandler()
{
/*
 * Interrupt Natural Language.
 */
nl_break(nlc);
return;
}


