/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlArg.C,v 1.2 1995/03/03 10:24:49 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlArg.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation of the CdlArg class that models
 *               arguments on methods in cdl.
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id [] = "$Id: CdlArg.C,v 1.2 1995/03/03 10:24:49 deans Exp $";

// System Includes
#include <string.h>
#include <stdlib.h>

// Local Includes
#include "CdlArg.H"
#include "CdlFile.H"

CdlArg *CdlArg::exemplarHead = NULL;
CdlArg *CdlArg::exemplarTail = NULL;

CdlArg::CdlArg (int e)
{
   nextExemplar = NULL;
   if (e == 1)
   {
     // This is an exemplar
     if (exemplarTail == NULL)
     {
        exemplarHead = exemplarTail = this;
     }
     else
     {
        exemplarTail->nextExemplar = this;
        exemplarTail = this;
     }
   }
}

CdlArg::~CdlArg ()
{
}

int CdlArg::setArgs (int, char *[])
{
   return 1;
}

CDL_ARG_DEF(CdlIntArg,int)

CdlIntArg::~CdlIntArg ()
{
}

ofstream &CdlIntArg::type (ofstream &of)
{
   of << "int";
   return of;
}

ofstream &CdlIntArg::initVarFromStr (char *varName, char *strName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "int " << varName << " = atoi(" << strName << ");" << endl;
   return of;
}

ofstream &CdlIntArg::cleanVarFromStr (char *, char *,
                                     ofstream &of, CdlIndent)
{
   return of;
}

ofstream &CdlIntArg::initStrFromVar (char *strName, char *varName,
                                     ofstream &of, CdlIndent tab)
{
   of << tab << strName << " = (char*)malloc(10*sizeof(char));" << endl;
   of << tab << "sprintf(" << strName << ",\"%d\"," << varName << ");" << endl;
   return of;
}

ofstream &CdlIntArg::cleanStrFromVar (char *strName, char *,
                                      ofstream &of, CdlIndent tab)
{
    of << tab << "free((char*)" << strName << ");" << endl;
   return of;
}


CDL_ARG_DEF(CdlFloatArg,float)

CdlFloatArg::~CdlFloatArg ()
{
}

ofstream &CdlFloatArg::type (ofstream &of)
{
   of << "float";
   return of;
}

ofstream &CdlFloatArg::initVarFromStr (char *varName, char *strName,
                                       ofstream &of,
                                       CdlIndent tab)
{
   of << tab << "float " << varName << " = atof(" << strName << ");" << endl;
   return of;
}

ofstream &CdlFloatArg::cleanVarFromStr (char *, char *,
                                     ofstream &of, CdlIndent)
{
   return of;
}

ofstream &CdlFloatArg::initStrFromVar (char *strName, char *varName,
                                     ofstream &of, CdlIndent tab)
{
   of << tab << strName << " = (char*)malloc(10*sizeof(char));" << endl;
   of << tab << "sprintf(" << strName << ",\"%f\"," << varName << ");" << endl;
   return of;
}

ofstream &CdlFloatArg::cleanStrFromVar (char *strName, char *,
                                      ofstream &of, CdlIndent tab)
{
    of << tab << "free((char*)" << strName << ");" << endl;
   return of;
}


CDL_ARG_DEF(CdlStrArg,str)

CdlStrArg::~CdlStrArg ()
{
}

ofstream &CdlStrArg::type (ofstream &of)
{
   of << "char *";
   return of;
}

ofstream &CdlStrArg::initVarFromStr (char *varName, char *strName, ofstream &of,
                                     CdlIndent tab)
{
   of << tab << "char *" << varName << " = " << strName << ";" << endl;
   return of;
}

ofstream &CdlStrArg::cleanVarFromStr (char *, char *,
                                     ofstream &of, CdlIndent)
{
   return of;
}

ofstream &CdlStrArg::initStrFromVar (char *strName, char *varName,
                                     ofstream &of, CdlIndent tab)
{
   of << tab << strName << " = strdup(" << varName << ");" << endl;
   return of;
}

ofstream &CdlStrArg::cleanStrFromVar (char *strName, char *,
                                      ofstream &of, CdlIndent tab)
{
    of << tab << "free((char*)" << strName << ");" << endl;
   return of;
}


CDL_ARG_DEF(CdlObrefArg,obref)

int CdlObrefArg::setArgs (int argc, char *argv[])
{
   if (argc != 1)
   {
      return 0;
   }
   className = strdup(argv[0]);
   return 1;
}

CdlObrefArg::~CdlObrefArg ()
{
   if (className)
   {
      free(className);
   }
}

ofstream &CdlObrefArg::type (ofstream &of)
{
   of << className << " *";
   return of;
}

ofstream &CdlObrefArg::initVarFromStr (char *varName, char *strName,
                                       ofstream &of,
                                       CdlIndent tab)
{
   of << tab << className << " *" << varName << " = (" << className << "*)"
      << "Otcl::otclPtr->obrefToCpp("
      << strName << ",\"" << className << "\");" << endl;
   return of;
}

ofstream &CdlObrefArg::cleanVarFromStr (char *, char *,
                                        ofstream &of, CdlIndent)
{
   return of;
}

ofstream &CdlObrefArg::initStrFromVar (char *strName, char *varName,
                                       ofstream &of, CdlIndent tab)
{
   of << tab << strName << " = (char*)malloc(10*sizeof(char));" << endl;
   of << tab << "strcpy(" << strName << "," 
      << "((" << className << OTCL_PART_SUFFIX << "*)" << varName << ")"
      << "->giveOwner()->getSelf()"
      << ");" << endl;
   return of;
}

ofstream &CdlObrefArg::cleanStrFromVar (char *strName, char *,
                                        ofstream &of, CdlIndent tab)
{
   of << tab << "free((char*)" << strName << ");" << endl;
   return of;
}
