#ifndef CDL_ARG_H
#define CDL_ARG_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlArg.H,v 1.2 1995/03/03 10:25:04 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlArg.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for CdlArg, and subclasses, that model argument
 *               of different types.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id_CdlArg_H [] = "IXI header $RCSfile: CdlArg.H,v $ $Revision: 1.2 $ ";

// System Includes
#include <fstream.h>

// Local Includes
#include "CdlItem.H"

#define CDL_ARG_DEC(a)      \
a (int e = 0);              \
char *giveCommand (void);   \
CdlArg *instantiate (void); \
static a exemplar;

#define CDL_ARG_DEF(a,b) \
a a :: exemplar(1); \
a :: a (int e) : CdlArg(e) {} \
char * a :: giveCommand (void) { \
   return #b; \
} \
CdlArg *a :: instantiate (void) \
{ \
   return new a; \
}


class CdlArg
{
public:
   CdlArg (int exemplar = 0);
   virtual char *giveCommand (void) = 0;
   virtual CdlArg *instantiate (void) = 0;

   virtual ~CdlArg ();
   virtual int setArgs (int argc, char *argv[]); 
   virtual ofstream &type (ofstream &) = 0;
   virtual ofstream &initVarFromStr (char *varName, char *strName,
                                     ofstream &, CdlIndent) = 0;
   virtual ofstream &cleanVarFromStr (char *varName, char *strName,
                                      ofstream &, CdlIndent) = 0;
   virtual ofstream &initStrFromVar (char *strName, char *varName,
                                     ofstream &, CdlIndent) = 0;
   virtual ofstream &cleanStrFromVar (char *strName, char *varName,
                                      ofstream &, CdlIndent) = 0;
   static CdlArg *exemplarHead;
   static CdlArg *exemplarTail;
   CdlArg *nextExemplar;

};

class CdlIntArg : public CdlArg
{
public:
   CDL_ARG_DEC(CdlIntArg)
   ~CdlIntArg ();
   ofstream &type (ofstream &);
   ofstream &initVarFromStr (char *localName, char *strName, ofstream &,
                             CdlIndent);
   ofstream &cleanVarFromStr (char *varName, char *strName,
                              ofstream &, CdlIndent);
   ofstream &initStrFromVar (char *strName, char *varName, ofstream &,
                             CdlIndent);
   ofstream &cleanStrFromVar (char *strName, char *varName, ofstream &,
                              CdlIndent);
};

class CdlFloatArg : public CdlArg
{
public:
   CDL_ARG_DEC(CdlFloatArg)
   ~CdlFloatArg ();
   ofstream &type (ofstream &);
   ofstream &initVarFromStr (char *localName, char *strName, ofstream &,
                             CdlIndent);
   ofstream &cleanVarFromStr (char *varName, char *strName,
                              ofstream &, CdlIndent);
   ofstream &initStrFromVar (char *strName, char *varName, ofstream &,
                             CdlIndent);
   ofstream &cleanStrFromVar (char *strName, char *varName, ofstream &,
                              CdlIndent);
};

class CdlStrArg : public CdlArg
{
public:
   CDL_ARG_DEC(CdlStrArg)
   ~CdlStrArg ();
   ofstream &type (ofstream &);
   ofstream &initVarFromStr (char *localName, char *strName, ofstream &,
                             CdlIndent);
   ofstream &cleanVarFromStr (char *varName, char *strName,
                              ofstream &, CdlIndent);
   ofstream &initStrFromVar (char *strName, char *varName, ofstream &,
                             CdlIndent);
   ofstream &cleanStrFromVar (char *strName, char *varName, ofstream &,
                              CdlIndent);
};

class CdlObrefArg : public CdlArg
{
public:
   CDL_ARG_DEC(CdlObrefArg)
   ~CdlObrefArg ();
   int setArgs (int, char *[]);
   ofstream &type (ofstream &);
   ofstream &initVarFromStr (char *localName, char *strName, ofstream &,
                             CdlIndent);
   ofstream &cleanVarFromStr (char *varName, char *strName,
                              ofstream &, CdlIndent);
   ofstream &initStrFromVar (char *strName, char *varName, ofstream &,
                             CdlIndent);
   ofstream &cleanStrFromVar (char *strName, char *varName, ofstream &,
                              CdlIndent);
private:
   char *className;
};

#endif // CDL_ARG_H

