#ifndef CDL_FILE
#define CDL_FILE

/*  _ __ ___ _
 * | |\ /  /| |  $Id: CdlFile.H,v 1.2 1995/03/03 10:25:09 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : CdlFile.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for CdlFile class that models the CDL input file.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id_CdlFile_H [] = "IXI header $RCSfile: CdlFile.H,v $ $Revision: 1.2 $ ";

// System Includes
#include <fstream.h>

// Tcl Includes
#include <tcl.h>

// Forwrard Class Declarations
class CdlItem;
class CdlMethod;

// Public Defines
#define MAX_ITEMS 20
#define OTCL_PART_SUFFIX "_otclp"
#define OTCL_CLASS_SUFFIX "_otclc"
#define STATIC_FLAG "-static"
#define DYNAMIC_FLAG "-dynamic"

class CdlFile
{
public:   // Public Constructor & Destructor

   CdlFile (char *name);

   ~CdlFile ();

public:  // Public Instance Methods

   // Returns 1 if OK, 0 o/w
   int parse (void);

   // Returns 1 if OK, 0 o/w
   int genOutput (char *name);

private:   // Private Instance Methods

   void rmvStdTclCmds (void);
  
   void addItemCmds (void);
   void rmvItemCmds (void);

   void addMethodCmds (void);
   void rmvMethodCmds (void);

   void addArgCmds (void);
   void rmvArgCmds (void);

   void addRtnCmds (void);
   void rmvRtnCmds (void);

   void genHeader (ofstream &);

   void genTrailer (ofstream &);

public:   // Public Class Methods

   static int classCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int constructorCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int methodCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int classMethodCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int argCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int rtnCmd (ClientData, Tcl_Interp *, int, char *[]);

   static int passCmd (ClientData, Tcl_Interp *, int, char *[]);

private:  // Private Instance Methods

   int newClass (int argc, char *argv[]);

   int constructor (int argc, char *argv[]);

   int method (int argc, char *argv[]);

   int classMethod (int argc, char *argv[]);

   int arg (int argc, char *argv[]);

   int rtn (int argc, char *argv[]);

   int pass (int argc, char *argv[]);

private:  // Private Instance Attributes

   CdlItem *item[MAX_ITEMS];
   int noOfItems;

   CdlMethod *methodUnderConstruction;

   Tcl_Interp *interp;

   char *name;
};

#endif // CDL_FILE_H

