#ifndef OTCL_H
#define OTCL_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: Otcl.H,v 1.2 1995/03/03 10:25:37 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : Otcl.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for the Object Tcl extensions
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id_Otcl_H [] = "IXI header $RCSfile: Otcl.H,v $ $Revision: 1.2 $ ";

// System Includes
#include <stdarg.h>

// Tcl Includes
#include <tcl.h>
#include <tclInt.h>

// local Includes
#include "OtclError.H"

// Command Name Defines
#define CLASS_INTERFACE_CMD      "otclInterface"
#define CLASS_IMPLEMENTATION_CMD "otclImplementation"
#define INSTANTIATE_CMD          "otclNew"
#define DISCARD_CMD              "otclDelete"
#define OTCL_CMD                 "otcl"
#define OTCL_NOP_CMD             "_otcl_nop_"

// Macro Definitions
#define ARGC_RANGE(lo,hi) if (argc < (lo) || argc > (hi)) 
#define ARGC_MIN(lo) if (argc < (lo))
#define ARGC_VALUE(val) if (argc != val)

// Public Defines
#define OTCL_TRUE 1
#define OTCL_FALSE 0
#define OTCL_ERR_BUF_SIZE 256

// Forward Class Declarations
class OtclClass;
class OtclClassOtcl;
class OtclClassCpp;
class OtclObjMgr;

// Class    : Otcl
// Synopsis : The OO extension to the Tcl_Interp structure.
// If a Tcl_Interp is created, using Tcl_CreateInterp, and the Otcl extension 
// is required for that interpreter then instantiate an Otcl object for it.
// Before the Tcl_Interp is delete, delete the Otcl object.
class Otcl
{
public:   // Public Constructors & Destructors

   // Constructor and initialiser for the Object Tcl extension
   Otcl (Tcl_Interp *, OtclObjMgr *objMgr);

   ~Otcl ();

public:   // Public Class Methods

   // The following static class methods are the Tcl command entry
   // points. The ClientData for argument is actually a pointer to the
   // Otcl object. The static methods pass the call on to the actual
   // instance method with the same name minus the "Cmd" suffix.

   static int classInterfaceCmd (ClientData, Tcl_Interp *,
                            int argc, char *argv[]);

   static int classImplementationCmd (ClientData, Tcl_Interp *,
                           int argc, char *argv[]);

   static int instantiateCmd (ClientData, Tcl_Interp *,
                              int argc, char *argv[]);

   static int discardCmd (ClientData, Tcl_Interp *,
                          int argc, char *argv[]);

   static int otclCmd (ClientData, Tcl_Interp *,
                int argc, char *argv[]);

   static int otclNopCmd (ClientData, Tcl_Interp *,
                          int argc, char *argv[]);

   static int classCmd (ClientData, Tcl_Interp *,
                        int argc, char *argv[]);

   static void setTclResult(Tcl_Interp *, char *format ...);
   static int setTclError(Tcl_Interp *, char *format ...);
   static void addTclErrorInfo(Tcl_Interp *, char *format ...);

   // Duplicates of private Tcl functions used to manage local variables
   static char *callTraces(Interp *, Var *, Var *, char *, char *, int);
   static void deleteArray(Interp *, char *, Var *, int);

public:  // Public Instance Methods

   // Used by OtclClassCpp::registerWithOtcl to register
   // the Otcl bound C++ classes
   void registerOtclClassCpp (OtclClassCpp *);

   OtclClass *giveOtclClass (char *className);

   int discard (Tcl_Interp *, char *symRef, int fromCpp);

   // A very interesting function :-) The void * is because all this
   // code is generic and doesn't have a clue what the class is!
   void *obrefToCpp (char *obref, char *cppClassName);

private: // Private Instance Methods

   int classInterface (Tcl_Interp *, int argc, char *argv[]);

   int classImplementation (Tcl_Interp *, int argc, char *argv[]);

   int instantiate (Tcl_Interp *, int argc, char *argv[]);

   int discard (Tcl_Interp *, int argc, char *argv[]);

   int otcl (Tcl_Interp *, int argc, char *argv[]);

   // Places CLASS_INTERFACE_CMD, CLASS_INTERNALS_CMD,
   // CONSTRUCT_CMD and DESTRUCT_CMD in scope.
   void placeCommandsInScope (Tcl_Interp *);

   // Removes the above commands from scope.
   void removeCommandsFromScope (Tcl_Interp *);

   // Clear out all classes 
   int clear (Tcl_Interp *);

private: // Private Instance Attributes

   // The available OtclClass objects keyed by their class name.
   Tcl_HashTable classes;

   // Object responsible for mapping objects to Tcl commands
   OtclObjMgr *objMgr;

public:  // Public Class Attributes

   static Tcl_Interp *tclInterp;

   static Otcl *otclPtr;

};

#endif // OTCL_H
