#ifndef OTCL_OBJ_MGR_H
#define OTCL_OBJ_MGR_H

/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclObjMgr.H,v 1.2 1995/03/03 10:26:06 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclObjMgr.H
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *  
 * Description : Header file for OtclObjMgr class and OtclObjMgrCmd class that
 *               mapps object references to Tcl commands.
 *
 * License     :
			Object Tcl License & Copyright
			-----------------------------

IXI ObjectT cl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id_OtclObjMgr_H [] = "IXI header $RCSfile: OtclObjMgr.H,v $ $Revision: 1.2 $ ";

// Tcl Includes
 #include <tcl.h>

// Forward Declarations
class OtclObject;

// Definitions
#define SYMBOLIC_REFERENCE_SIZE 10

class OtclObjMgr
{
public:    // Destructor

   OtclObjMgr ();

public:   // Public Instance Methods

   // Returns a NULL terminate string containing the symbolic handle to the
   // object for use within Tcl as a command.
   // The char * returned is an internal attribute that
   // is valid until the next call to OtclObjMgr.
   virtual char *manageObject (OtclObject *, Tcl_Interp *) = 0;

   // Returns the OtclObject unManaged or NULL if not a managed object
   virtual OtclObject *unManageObject(char *symbolicRef, Tcl_Interp *) = 0;

   virtual OtclObject *dereference (char *symbolicRef, Tcl_Interp *) = 0;

protected: // Constructor

   // Protected so that OtclObjMgr is abstract!
   virtual ~OtclObjMgr ();

protected:  // Protected Instance Attributes

   char symRef[SYMBOLIC_REFERENCE_SIZE];

};

// To manage OtclObjects using the Tcl command table.
class OtclObjMgrCmd : public OtclObjMgr
{
public:   // Constructor & Destructor

   OtclObjMgrCmd ();

   virtual ~OtclObjMgrCmd ();

public:  // Public Instance Methods

   char *manageObject (OtclObject *, Tcl_Interp *);

   OtclObject *unManageObject(char *symbolicRef, Tcl_Interp *);

   OtclObject *dereference (char *symbolicRef, Tcl_Interp *);

   int obj (OtclObject *, Tcl_Interp *, int argc, char *argv[]);

public:  // Public Class Methods

   static int objCmd (ClientData, Tcl_Interp *, int argc, char *argv[]);

private: // Private Class

   class MgrAndObjPair
   {
   public:
      MgrAndObjPair (OtclObjMgrCmd *m, OtclObject *o)
      {
         otclmc = m;
         otclo = o;
      }
      OtclObjMgrCmd *otclmc;
      OtclObject *otclo;
   };

};

#endif // OTCL_OBJ_MGR_H
