/*  _ __ ___ _
 * | |\ /  /| |  $Id: OtclObject.C,v 1.2 1995/03/03 10:26:10 deans Exp $
 * | | /  / | |  Copyright (C) 1995 IXI Limited.
 * |_|/__/_\|_|  IXI Limited, Cambridge, England.
 *
 * Component   : OtclObject.C
 *
 * Author      : Dean Sheehan (deans@x.co.uk)
 *
 * Description : Contains the implementation for OtclObjeect class that modesl
 *               instances of classes (C++ or Object Tcl classes).
 *
 * License     :
			Object Tcl License & Copyright
			------------------------------

IXI Object Tcl software, both binary and source (hereafter, Software) is copyrighted by IXI Limited (IXI), and ownership remains with IXI. 

IXI grants you (herafter, Licensee) a license to use the Software for academic, research and internal business purposes only, without a fee. Licensee may distribute the binary and source code (if required) to third parties provided that the copyright notice and this statement appears on all copies and that no charge is associated with such copies. 

Licensee may make derivative works. However, if Licensee distributes any derivative work based on or derived from the Software, then Licensee will (1) notify IXI regarding its distribution of the derivative work, and (2) clearly notify users that such derivative work is a modified version and not the original IXI Object Tcl distributed by IXI. IXI strongly recommends that Licensee provide IXI the right to incorporate such modifications into future releases of the Software under these license terms. 

Any Licensee wishing to make commercial use of the Software should contact IXI, to negotiate an appropriate license for such commercial use. Commercial use includes (1) integration of all or part of the source code into a product for sale or license by or on behalf of Licensee to third parties, or (2) distribution of the binary code or source code to third parties that need it to utilize a commercial product sold or licensed by or on behalf of Licensee. 

IXI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THIS SOFTWARE FOR ANY PURPOSE. IT IS PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY. IXI SHALL NOT BE LIABLE FOR ANY DAMAGES WHATSOEVER SUFFERED BY THE USERS OF THIS SOFTWARE. 

Copyright (C) 1995, IXI Limited 

By using or copying this Software, Licensee agrees to abide by the copyright law and all other applicable laws of England and the U.S., including, but not limited to, export control laws, and the terms of this license. IXI shall have the right to terminate this license immediately by written notice upon Licensee's breach of, or non-compliance with, any of its terms. Licensee may be held legally responsible for any copyright infringement that is caused or encouraged by Licensee's failure to abide by the terms of this license. 

Comments and questions are welcome and can be sent to
otcl@x.co.uk 

For more information on copyright and licensing issues, contact: 
Legal Department, IXI Limited, Vision Park, Cambridge CB4 4ZR,
ENGLAND. 

 *
 */

static char rcs_id [] = "$Id: OtclObject.C,v 1.2 1995/03/03 10:26:10 deans Exp $";

// Local Includes
#include "OtclObject.H"
#include "OtclClass.H"
#include "OtclPart.H"

// Local Defines
#define UNKNOWN_METHOD_NAME "unknown"

OtclObject::OtclObject ()
{
   otclop = NULL;
   self = NULL;
   discarding = OTCL_FALSE;
}

OtclObject::~OtclObject ()
{
   if (otclop != NULL)
   {
      delete otclop;
   }
   if (self != NULL)
   {
      free(self);
   }
}

void OtclObject::setSelf (char *s)
{
   self = strdup(s);
}

void OtclObject::setPart (OtclPart *part)
{
   otclop = part;
}

int OtclObject::discard (Tcl_Interp *interp, int fromCpp)
{
   discarding = OTCL_TRUE;

   // discardPart also 'deletes' the part!
   int returnCode = otclop->discardPart(interp,fromCpp);

   otclop = NULL;

   delete this;

   return returnCode;
}

void OtclObject::addObjectScope (Tcl_Interp *interp)
{
   Tcl_SetVar(interp,OTCL_SELF_ATTRIBUTE,self,0);
}

void OtclObject::removeObjectScope (Tcl_Interp *)
{
   // remove self attribute
   // This is done when the call frame is cleaned up
   // by the OtclClass::destroyClassScope
}

int OtclObject::executeMethod (Tcl_Interp *interp, char *methodName,
                               int argc, char *argv[])
{
   int found = OTCL_FALSE;
   int result;
   if (*methodName == '-')
   {
      // Need to check the number of arguments as well!!!!!

      // Special case. The method name is -<Parent> where Parent is the
      // name of the superclass where to find the method (or start searching
      // from anyway). The OTCL_PART_ATTRIBUTE_NAME in the current interp
      // frame specifies the current OtclPart that is calling (if any)
      char *otclPartStr = Tcl_GetVar2(interp,OTCL_PART_ATTRIBUTE_NAME,NULL,0);
      if (otclPartStr == NULL)
      {
         // Couldn't have been calling from inside any instance method
         // Error !
         return TCL_ERROR;
      }
      OtclPartOtcl *otclpPtr;
      sscanf(otclPartStr,"%lx",(long**)&otclpPtr);
      result = otclpPtr->executeParentMethod(interp,methodName+1,
                                             argv[0],argc - 1, & argv[1],
                                             &found);
   }
   else
   {
      // Search the heirarchy for the method
      result = otclop->executeMethod(interp,methodName,argc,argv,&found);
   }

   if (found == OTCL_FALSE)
   {
      // Look for a method called "unknown" in the class

      // Build and argv structure that has the actual method name as the
      // first argument and then try to execute the "unknoewn" method.
      // Free the new argv structure afterwards

      int newArgc = argc+1;
      char **newArgv = (char**)malloc(newArgc * sizeof(char*));
      newArgv[0] = methodName;
      for (int i = 0; i < argc; i++)
      {
         newArgv[i+1] = argv[i];
      }
      result = otclop->executeMethod(interp,UNKNOWN_METHOD_NAME,
                                      newArgc,newArgv,&found);
      free((char*)newArgv);

      if (found == OTCL_TRUE)
      {
         return result;
      }

      Otcl::setTclResult(interp,INST_METHOD_NOT_FOUND_ERR,methodName,
                         otclop->giveClassName());
      return TCL_ERROR;
   }
   else
   {
      return result;
   }
}

OtclPart *OtclObject::giveOtclPart (void)
{
   return otclop;
}

char *OtclObject::getSelf (void)
{
   return self;
}

int OtclObject::discardingParts (void)
{
   return discarding;
}

void *OtclObject::toCpp (char *cppClassName)
{
   return otclop->toCpp(cppClassName);
}
