'\"
'\" Copyright 1992 Sven Delmas
'\"
'\" The manual page is based upon the manual page style from:
'\"
'\" Copyright 1992 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: xaccess.n[10.0] Wed May  4 23:55:04 1994 garfield@mydomain.de frozen $
'/" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS xaccess cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
xaccess \- Access to various X functions from Tcl
.SH SYNOPSIS
\fBxaccess\fI command \fR?\fIoptions\fR?\fR
.BE
.SH DESCRIPTION
.PP
The \fBxaccess\fR command provides access to certain X
functions like sending events, manipulation of properties,
reading of the X window structure and the X bell. The
commands were written to allow the embedding of external
applications into Tk.
.PP
For almost all xaccess commands, the user has to specify an X
window id (with the \fI-windowid\fR option) or a Tk widget
pathname (with the \fI-widget\fR option).
.PP
The following commands can be specified:
.TP
\fBeventbuttonpress \fR?\fIoptions\fR?
A \fIbuttonpressed\fR event is sent, where the \fI-button\fR
parameter specifies which button should be pressed. Accepted
values are numbers from 1 to 5. The \fI-state\fR parameter
selects a certain button mask. The value of this paramter is
one of the usual Modifiers (Control, Shift, Lock, Button?,
Mod?).
.TP
\fBeventbuttonrelease \fR?\fIoptions\fR?
A \fIbuttonreleased\fR event is sent, where the
\fI-button\fR parameter specifies which button should be
released. The parameters are the same as for the
\fBbuttonpressed\fR event.
.TP
\fBeventclientmessage \fR?\fIoptions\fR?
When sending a \fIclientmessage\fR event, the user can
define the format of the message with the \fI-format\fR
option. The \fI-messagetype\fR or \fI-messagetypename\fR
specifies an atom id or atom name that should be sent. For a
detailed description of the parameters, take a look at the X
event description.
.TP
\fBeventconfigure \fR?\fIoptions\fR?
A \fIconfigure\fR event allows the setting of the following
options: the \fI-x\fR, \fI-y\fR, \fI-width\fR, \fI-height\fR
dimensions of the window. The \fI-borderwidth\fR option
allows the setting of the window's borderwidth. The selected
X window is stacked above the X window selected with the
\fI-abovewindowid\fR or \fI-abovewidget\fR options. The
option \fI-overrideredirect\fR allows the specifying of the
overrideredirect attribute of the selected X window. For a
detailed description of the parameters, take a look at the X
event description.
.TP
\fBeventexpose \fR?\fIoptions\fR?
For the \fIexpose\fR event the user can specify the
following options (with the same meaning as for the
\fIconfigure\fR event): \fI-x\fR, \fI-y\fR, \fI-width\fR,
\fI-height\fR.
.TP
\fBeventkeypress \fR?\fIoptions\fR?
A \fIkeypressed\fR event is sent, where the \fI-keysym\fR
parameter specifies which key should be pressed. Accepted
values are all keysyms that are defined in
<X11/keysymdefs.h>. The \fI-state\fR parameter selects the
a certain key mask. The value of this paramter is one of the
usual Modifiers (Control, Shift, Lock, Button?, Mod?).
.TP
\fBeventkeyrelease \fR?\fIoptions\fR?
A \fIkeyreleased\fR event is sent, where the \fI-keysym\fR
parameter specifies which key should be released. The
parameters are the same as for the \fBkeypressed\fR event.
.TP
\fBeventmap \fR?\fIoptions\fR?
The \fImap\fR event knows the following options (with the
same meaning as for the \fIconfigure\fR event):
\fI-overrideredirect\fR.
.TP
\fBeventmotion \fR?\fIoptions\fR?
With this event, the user can move the mouse pointer to a
new location. Settable parameters are \fI-x\fR, \fI-y\fR,
\fI-xroot\fR, \fI-yroot\fR and \fI-relative\fR. The
\fI-relative\fR option specifies whether or not the mouse
pointer is placed referring to the current position or with
absolute coordinates. When the \fI-windowid\fR or
\fI-widget\fR options are set, the mouse pointer is placed
relative to that window. The \fI-interval\fR option can be
used to specify a move distance for the mouse. The mouse
pointer will be moved the given amount of pixels, until the
final position is reached. The value is given as a float
(although only integer positions are displayed). With values
smaller than 1, the mouse pointer motion is slowed down.
.TP
\fBeventreparent \fR?\fIoptions\fR?
With the \fIreparent\fR event, the specified window is
reparented to the window specified with the
\fI-parentwindowid\fR or \fI-parentwidget\fR option.
.TP
\fBpropget \fR?\fIoptions\fR?
If the user does not specify any options for the
\fIpropget\fR command besides the window id (widget name),
all property ids attached to that window are returned. To
retrieve the value of one specific property, the user can
specify the property id with the option \fI-property\fR, or
the property name with the option \fI-propertyname\fR. Only
properties with the type string can be retrieved. The
returned value is a list with three or more elements. The
first element is the name of the property, the second
element is the type of the property, and the following
elements are the values of the property (usually only one
value, but if there are '\\0' characters in the string, the
value is split into separate elements). The following
options can be optionally specified (take a look at the
specification of the \fIXGetWindowProperty(3X)\fR function):
\fI-longoffset\fR, \fI-longlength\fR, \fI-delete\fR,
\fI-type\fR.
.TP
\fBpropchange \fR?\fIoptions\fR?
To change the value of a property (or to create a new
property), the \fIpropchange\fR command is used. The
specified property (\fI-property\fR or \fI-propertyname\fR)
is created or changed. The user can define how the new data
is attached to the property with the \fI-mode\fR option.
Possible values are ''append'', ''prepend'' or ''replace''.
The data that should be attached is specified with the
\fI-data\fR option. The \fI-numelements\fR defaults to the
length of the data string, but can also be set directly.
The default type (STRING) can be changed with the
\fI-type\fR resource. All types that are available for
properties can be specified (well, almost all...). By
default, the format of the data is 8 bit, but this can be
changed with the \fI-format\fR option. Take a look at the
specification of the \fIXChangeProperty(3X)\fR function to
get a complete description of the parameters.
.TP
\fBpropdelete \fR?\fIoptions\fR?
The \fIpropdelete\fR command deletes the named property
(\fI-property\fR or \fI-propertyname\fR) from the specified
X window.
.TP
\fBsendstring \fR?\fIoptions\fR?
The \fIsendstring\fR command sends a complete string to the
specified X window. The string is specified with the
\fI-data\fR option, and can contain a standard character
(e.g. "abCDe+-?"), modifiers enclosed in <> (e.g.
"ab<Control>n"), keysyms also enclosed in <> (e.g.
"ab<Enter>"), and the special modifier extensions "Press"
and "Release" (e.g. "ab<Press-Shift>aaa<Release-Shift>").
The escape sequences '\\t' (for tabulator), '\\r' (for
return), '\\n' (for return), and '\\b' (for backspace) are
also accepted. The \fI-interval\fR option can be used to
add a delay to the keypress events (to emulate some kind of
user speed typing). The value is given in seconds.
.TP
\fBxbell \fR?\fIoptions\fR?
With the \fIxbell\fR command, the X bell is rung. The option
\fI-volume\fR allows it to set the volume. The option
\fI-interval\fR can be used to specify a list of integer
values (seconds) that form a sequence of bell rings.
.TP
\fBxwinchilds \fR?\fIoptions\fR?
With the \fIxwinchilds\fR command, the X window ids that
are children of the passed X window id are returned.
.TP
\fBxwinname \fR?\fIoptions\fR?
With the \fIxwinname\fR command, the name attached to an X
window is retrieved (if there is one).
.TP
\fBxwinparent \fR?\fIoptions\fR?
With the \fIxwinparent\fR command, the X window id that is
the parent of the passed X window id is returned.
.TP
\fBxwinroot \fR?\fIoptions\fR?
With the \fIxwinroot\fR command, the X window id that is the
root of the passed X window id is returned.

.SH BUGS
.PP
.\"
.IP "\(bu"
Surely, there are many bugs.

.SH KEYWORDS
X, XSendEvent(3X), XReparentWindow(3X), XQueryTree(3X),
XFetchName(3X), XGetWindowProperty(3X), XChangeProperty(3X),
XWarpPointer(3X)
