'\"
'\" Copyright (c) 1990 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/after.n,v 1.11 93/04/01 09:52:08 ouster Exp $ SPRITE (Berkeley)
'\" 
.so man.macros
.HS after tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
after \- Execute a command after a time delay
.SH SYNOPSIS
\fBafter \fIms \fR?\fIarg1 arg2 arg3 ...\fR?
.PP
\fBafter \fBpending \fR?\fB-exact\fR? \fR?\fIarg1 arg2 arg3 ...\fR?
.PP
\fBafter \fBabort \fR?\fB-exact\fR? \fR?\fIarg1 arg2 arg3 ...\fR?
.PP
\fBafter \fBunique \fR?\fB-exact\fR? \fR?\fB-reschedule\fR? \fIms arg1 \fR?\fIarg2 arg3 ...\fR?
.PP
\fBafter \fBoverride \fR?\fB-exact\fR? \fR?\fB-reschedule\fR? \fIms arg1 \fR?\fIarg2 arg3 ...\fR?
.BE

.SH DESCRIPTION
.PP
This command is used to delay execution of the program or to execute
a command in background after a delay.  The \fIms\fR argument gives
a time in milliseconds.
If \fIms\fR is the only argument to \fBafter\fR
then the command sleeps for \fIms\fR milliseconds and returns.
While the command is sleeping the application does not respond to
X events and other events.
.PP
If additional arguments are
present after \fIms\fR, then a Tcl command is formed by concatenating
all the additional arguments in the same fashion as the \fBconcat\fR
command.  \fBAfter\fR returns immediately but arranges for the command
to be executed \fIms\fR milliseconds later in background.
The command will be executed at global level (outside the context
of any Tcl procedure).
If an error occurs while executing the delayed command then the
\fBtkerror\fR mechanism is used to report the error.
.PP
.VS
The \fBafter\fR command returns an empty string if no options are set.
.VE
.PP
.VS
The \fBpending\fR subcommand queries
sleeping commands scheduled with \fBafter\fR. The return value is a list
of the waiting commands. Each list element is a list itself,
consisting of the number of milliseconds remaining until
execution and the command script. The time value
may be negative if the execution was delayed. If no arguments are present,
all queued commands are reported. With arguments, those
commands with a first word equal to \fIarg1\fR, or, if the
\fB-exact\fR option is given,  commands matching the
template exactly are returned. Note that it is safe to use the
following commands to manipulate the dormant command set because Tk
calls timer functions only from the main loop, never in
interrupts. So once you determined the presence of a function,
it remains queued unchanged during the current procedure call. 
On the other hand this means also that you cannot wait in a 
procedure for the pending commands to drain by just looping or
calling something like \fBafter\fR \fIwaitperiod\fR because the
control flow does not return to the main loop. The only way to
have waiting events (in general, not only queued commands) processed
within the current proc is to call \fBupdate\fR. Saved lists
of \fBafter pending\fR become obsolote only after \fBupdate\fR
and the following \fBafter\fR command extensions.
.PP
A function which is executed as the effect of an \fBafter\fR
command will not see itself in the pending command list.
.VE
.PP
.VS
The \fBabort\fR subcommand cancels scheduled commands before
they have been executed. If no arguments are given, all pending
commands are removed. Otherwise, those commands with the first
command word identical to \fIarg1\fR or, with the \fB-exact\fR flag,
commands matching the argument list exactly are aborted. \fBafter abort\fR
returns the number of cancelled commands.
.VE
.PP
.VS
The \fBunique\fR subcommand prevents the submission of multiple
identical commands. If a command which matches \fIarg1\fR or, with
\fB-exact\fR, the complete argument list, is already scheduled, the
command is not submitted and a 0 is returned. Otherwise, the
\fBafter unique\fR returns 1 and submits a new command in the
standard fashion. If the \fB-reschedule\fR flag is set and a 
matching sleeping command is found, the timer value is
transferred to the original command, typically delaying its execution,
but speedup is also possible.
.VE
.PP
.VS
The \fBoverride\fR subcommand edits the contents of a command scheduled
by another \fBafter\fR command. As usual
a command which matches either \fIarg1\fR, or, with \fB-exact\fR,
the whole argument list, is selected. The argument list of this
\fBafter\fR instruction
defines the new script. If no matching command is found, 
a new command is scheduled in the normal way, provided the
\fB-nonew\fR flags is not set. If the \fB-reschedule\fR flag
is present and a matching sleeping command is found,
the timer value is transferred
together with the new script. Otherwise, the edited command is executed at
its originally specified time. If a pending command was actually
overridden, 1 is returned, otherwise 0. If both the \fB-exact\fR and
\fB-reschedule\fR flags are set, the effects are the same as \fB-unique\fR
with the same flag set.
.VE

.SH "SEE ALSO"
tkerror, update

.SH BUGS
.VS
.PP
The timer handler creation routine \fITk_CreateTimerHandler()\fR
returns only an integer token, not a pointer to the timer queue
entry which contains the decoded absolute time for execution.
In order to avoid patching the internals of Tk, the new
\fBafter\fR command implements duplicate time fields for the scheduled
commands. Because \fIgettimeofday()\fR is called twice, the
time value reported by \fBafter pending\fR and the actually set
execution time may be off by a few milliseconds.
.VE

.SH KEYWORDS
delay, sleep, time, schedule, submit, cancel, pending

.SH INITIALIZATION
.PP
Add a line to \fITcl_AppInit()\fR which reads
.PP
\fIif (NewAfter_Init(interp)!=TCL_OK) return TCL_ERROR;\fR
.PP
This function replaces the old \fBafter\fR command. The extended command
is fully compatible with the old \fBafter\fR command syntax.
.SH CONTACT
The source is maintained by Wolf-D. Ihlenfeldt, email wolf@molout.tutkie.tut.ac.jp. Send mail for questions, suggestions and bug reports.
