#
# System.tcl,v 1.7 1992/08/03 20:49:22 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/System.tcl,v 1.7 1992/08/03 20:49:22 snl Exp
#
# HISTORY
#
# System.tcl,v
# Revision 1.7  1992/08/03  20:49:22  snl
# storage fundas
#
# Revision 1.6  1992/07/31  20:11:42  snl
# Massive checkin
#
# Revision 1.5  1992/07/22  17:18:16  snl
# Additions needed for new storage primitives
#
# Revision 1.4  1992/07/14  03:03:03  snl
# Added hooks for storage stuff, bug fixes
#
# Revision 1.3  1992/06/29  04:11:56  snl
# added save method
#
# Revision 1.2  1992/05/09  15:59:33  snl
# test
#
# Revision 1.1.1.1  92/05/08  19:46:11  snl
# bos 1.2
# 
# Revision 1.2  92/03/09  01:25:28  snl
# release 1.2 final
# 
# Revision 1.1  92/03/08  23:33:43  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:46  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:12:43  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:48  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:35:06  snl
# Initial revision
# 
#
# Bos: Basic Object System -*- text -*-
#
# /afs/cs/project/edrc/ndim/source/bos/base/System.tcl,v 1.7 1992/08/03 20:49:22 snl Exp
# HISTORY
#
# System.tcl,v
# Revision 1.7  1992/08/03  20:49:22  snl
# storage fundas
#
# Revision 1.6  1992/07/31  20:11:42  snl
# Massive checkin
#
# Revision 1.5  1992/07/22  17:18:16  snl
# Additions needed for new storage primitives
#
# Revision 1.4  1992/07/14  03:03:03  snl
# Added hooks for storage stuff, bug fixes
#
# Revision 1.3  1992/06/29  04:11:56  snl
# added save method
#
# Revision 1.2  1992/05/09  15:59:33  snl
# test
#
# Revision 1.1.1.1  92/05/08  19:46:11  snl
# bos 1.2
# 
# Revision 1.2  92/03/09  01:25:28  snl
# release 1.2 final
# 
# Revision 1.1  92/03/08  23:33:43  snl
# Initial revision
# 
# Revision 1.2  92/01/27  16:06:46  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:12:43  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:42:48  snl
# Initial revision
# 
# Revision 1.1  91/12/16  19:35:06  snl
# Initial revision
# 
#

SystemTraits defMethod say {msg} {
  global QUIET
  if !$QUIET {
    puts stdout "# $msg"
  }
}
SystemTraits defMethod undefMethod {name} {
  %bosRemoveSlot $self $name
  return $name
}
SystemTraits defMethod addSlot {name value {type normal} {pri 0} {addOnly 0}} {
  if $addOnly {
    %bosAddSlot $self $name $type $pri $value
  } else {
    %bosAddOrSetSlot $self $name $type $pri $value
  }
  return $name
}
SystemTraits defMethod set {name value} {
  %bosSetSlot $self $name value $value
  return $name
}
SystemTraits defMethod setPri {name pri} {
  %bosSetSlot $self $name pri $pri
  return $name
}
SystemTraits defMethod setType {name type} {
  %bosSetSlot $self $name type $type
  return $name
}
SystemTraits defMethod setName {name new_name} {
  %bosSetSlot $self $name name $new_name
  return $new_name
}
SystemTraits defMethod removeSlot {name} {
  %bosRemoveSlot $self $name
  return $name
}
SystemTraits defMethod die {} {
  %bosDestroy $self
  return $self
}
SystemTraits defMethod _slots {} {
  lindex [%bosGetSlots $self] 0
}
SystemTraits defMethod _slot {name} {
  lindex [%bosGetSlots $self $name] 0
}
SystemTraits defMethod _slotNames {} {
  set slots [$self _slots]
  set names {}
  foreach s $slots {
    set names [concat $names [lindex $s 0]]
  }
  return $names
}
SystemTraits defMethod AYT {} {return 1}
SystemTraits defMethod refineWith {newName} {
  set newTraitsName [format "%sTraits" $newName]
  if {![catch {$newTraitsName AYT}]} {
    return $newName
  }
  set newParentName [lc0 [format "%sParent" $newName]]
  set parent [$self _pointers]
  if {[expr {[llength $parent] > 1}]} {
    error [format "%s -> %s not a simple refinement." $self $newName]
  }
  set parent [lindex $parent 0]
  set parentObj [$self $parent]
  Object copy $newTraitsName
  $newTraitsName addSlot $parent $parentObj object
  if {[string compare $parent systemParent]} {
    $newTraitsName removeSlot systemParent
  }
  $self copy $newName
  $newName addSlot $newParentName $newTraitsName object
  $newName removeSlot $parent
  return $newName
}
SystemTraits defMethod hideSuper {name} {
  $self defMethod $name {args} {
    error [format "%s invoked disallowed operation." $self]
  }
  return $name
}
SystemTraits defMethod ++ {slotName} {
  set n [expr {[$self $slotName] + 1}]
  $self set $slotName $n
  return $n
}
SystemTraits defMethod -- {slotName} {
  set n [expr {[$self $slotName] - 1}]
  $self set $slotName $n
  return $n
}
SystemTraits defMethod gensym {{prefix G}} {
  if {[SystemTraits _gensymUniqueness] == 0} {
    set g [format %s%04d $prefix [SystemTraits _gensymCounter]]
    SystemTraits ++ _gensymCounter
  } else {
    if {[SystemTraits _gensymUniqueness] == 1} {
      set g [format %s_%s%04d [username] $prefix [SystemTraits _gensymCounter]]
      SystemTraits ++ _gensymCounter
    } else {
      if {[SystemTraits _gensymUniqueness] > 1} {
	set r [SystemTraits _gensymRadix]
	set c [SystemTraits _gensymCounter]
	set g [format $prefix%s%s%s%s \
	  [toradix $r [ipaddress]] \
	  [toradix $r [userid]] \
	  [toradix $r [now]] \
	  [toradix $r $c]]
	if {$c >= [SystemTraits _gensymCycle]} {
	  SystemTraits set _gensymCounter 0
	} else {
	  SystemTraits ++ _gensymCounter
	}
      }
    }
  }
  return $g
}
SystemTraits defMethod _saveGensymState {filename} {
  set f [open $filename w]
  puts $f "SystemTraits set _gensymUniqueness [SystemTraits _gensymUniqueness]\n"
  if {[SystemTraits _gensymUniqueness] == 0} {
    puts $f "SystemTraits _setMin _gensymCounter [SystemTraits _gensymCounter]\n"
  } else {
    if {[SystemTraits _gensymUniqneness] == 1} {
      puts $f "SystemTraits _setMin _gensymCounter [SystemTraits _gensymCounter]\n"
    } else {
      if {[SystemTraits _gensymUniqueness] > 1} {
	puts $f "SystemTraits _setMin _gensymCounter [SystemTraits _gensymCounter]\n"
        puts $f "SystemTraits set _gensymRadix [SystemTraits _gensymRadix]\n"
        puts $f  "SystemTraits _setMin _gensymCycle [SystemTraits _gensymCycle]\n"
      }
    }
  }
  close $f
}
SystemTraits defMethod _setMin {what minval} {
  if {[$self $what] < $minval} {
    $self set $what $minval
  }
}
SystemTraits defMethod search {attribute bool value} {
  return [%bosSearch $attribute $bool $value]
}
SystemTraits defMethod save {{dir OBJECTS} {lock_file 0}} {
  %bosSave $self $dir $lock_file;
}
SystemTraits defMethod reload {{dir OBJECTS} {lock_file 0}} {
  %bosLoad $self $dir $lock_file;
}
SystemTraits defMethod loadObject {obj {dir OBJECTS} {lock_file 0}} {
  puts stdout "# Debug: loading object $obj dir=$dir lock=$lock_file";
  %bosLoad $obj $dir $lock_file;
}
SystemTraits defMethod isSaved {{dir OBJECTS} {lock_file 0}} {
  return [System objIsStored $self $dir $lock_file];
}
SystemTraits defMethod objIsStored {obj {dir OBJECTS} {lock_file 0}} {
  set result [%bosInStore $obj $dir $lock_file];
  return $result;
}
SystemTraits defMethod flushObjectStore {} {
  %bosCloseObjectFiles;
}
SystemTraits defMethod compactStorage {dir} {
  %bosCompactStorage $dir;
}
SystemTraits defMethod unsave {{dir OBJECTS} {lock_file 0}} {
  %bosRemove $self $dir $lock_file;
}
SystemTraits defMethod dumpStorageInfo {} {
  %bosDumpStorageStatus;
}
SystemTraits defMethod listStoredObjects {{dir OBJECTS}} {
  return [%bosListStoredObjects $dir];
}

#SystemTraits addSlot _gensymRadix 80
SystemTraits addSlot _gensymRadix 62
SystemTraits addSlot _gensymCounter 0
SystemTraits addSlot _gensymCycle 99
#SystemTraits addSlot _gensymUniqueness 0
SystemTraits addSlot _gensymUniqueness 2
