#
# util.tcl,v 1.1 1992/05/21 04:07:44 snl Exp
#
# /afs/cs/project/edrc/ndim/source/bos/base/util.tcl,v 1.1 1992/05/21 04:07:44 snl Exp
#
# HISTORY
#
# util.tcl,v
# Revision 1.1  1992/05/21  04:07:44  snl
# moved in some files from ndim/workspace
#
# Revision 1.1.1.1  1992/05/08  19:32:03  snl
# n-dim 0.82
#
# Revision 1.3  92/04/22  01:08:24  snl
# added abs
# 
# Revision 1.2  92/01/27  15:49:19  snl
# Port to new TCL
# 
# Revision 1.1  91/12/16  20:22:15  snl
# Initial revision
# 
#
# ++ and reqresize by Dino
proc ++ v {uplevel set $v [expr "[uplevel set $v] + 1"]}
proc -- v {uplevel set $v [expr "[uplevel set $v] - 1"]}
proc first {list} {lindex $list 0}
proc rest {list} {lrange $list 1 end}
proc last {list} {
  set l [llength $list]
  -- l
  return [lindex $list $l]
}

proc reqresize { name } {
  update
  resize $name [winfo reqw $name] [winfo reqh $name]
}

# popup menu
proc popupmenu.post { name x y } {
  $name post [expr {$x - [winfo width $name]/2}] $y $name.group
 }

proc popupmenu.bind { name } {
  bind $name <Any-Enter> "$name activate @%y"
  bind $name <Any-Leave> "$name activate none"
  bind $name <Any-Motion> "$name activate @%y"
  bind [winfo parent $name] <2> "popupmenu.post $name %X %Y"
  bind [winfo parent $name] <ButtonRelease-2> "$name unpost; $name invoke active"
}

proc popupmenu { name } {
  menu $name
  sharedgroup $name.group
  $name.group add [winfo parent $name]
  popupmenu.bind $name
  return $name
}

# from the widget demo
proc bs {win {min 0}} {
    set x [expr {[$win index cursor] - 1}]
    if {$x >= $min} {$win delete $x}
}

proc bind.menu args {
    foreach w $args {
	bind $w <Any-Enter> "$w activate @%y"
	bind $w <Any-Leave> "$w activate none"
	bind $w <Any-Motion> "$w activate @%y"
	bind $w <ButtonRelease-1> "$w invoke active"
    }
}

proc bind.menubutton args {
    foreach w $args {
	bind $w <Enter> "$w activate"
	bind $w <B1-Enter> "$w activate; $w config -relief sunken; $w post"
	bind $w <B1-Leave> "$w deactivate; $w config -relief flat"
	bind $w <Shift-B1-Leave> "$w deactivate; $w config -relief flat"
	bind $w <Leave> "$w deactivate"
	bind $w <1> "$w config -relief sunken; $w post"
	bind $w <Shift-1> "$w.m post %X %Y"
	bind $w <ButtonRelease-1> "$w config -relief flat; $w unpost"
	bind $w <Shift-B1-Motion> "$w.m post %X %Y"
    }
}

proc lowercaseChar {chr} {
  scan $chr %c ch
  if {$ch >= 65 && $ch <= 90} {
    return [format %c [expr {$ch + 32}]]
  } else {
    return $chr
  }
}

proc lowercase {str} {
  return [string tolower $str]
}

proc uppercaseChar {chr} {
  scan $chr %c ch
  if {$ch >= 97 && $ch <= 122} {
    return [format %c [expr {$ch - 32}]]
  } else {
    return $chr
  }
}

proc uppercase {str} {
  return [string toupper $str]
}

proc lc0 {str} {
  scan [string index $str 0] %c c0
  if {$c0 < 65 || $c0 > 90} {return $str}
  set c0 [expr {$c0 + 32}]
  return [format %c%s $c0 [string range $str 1 end]]
}

proc uc0 {str} {
  scan [string index $str 0] %c c0
  if {$c0 >= 97 && $c0 <= 122} {
    set c0 [expr {$c0 - 32}]
    set str [format %c%s $c0 [string range $str 1 end]]
  }
  return $str
}

     
proc link.source { name } {
  if {![string compare [string index $name 0] .]} {
    set name [winfo name $name]
  }
  return [file dirname [file dirname $name]]
}

proc link.target { name } {
  
  if {![string compare [string index $name 0] .]} {
    set name [winfo name $name]
  }
  return [file tail [file dirname $name]]
}

proc abs {n} {
  if {$n < 0} {
    return [expr {-$n}]
  } else {
    return $n
  }
}
