/* be.c - BOS Environment
 *
 * Copyright (C) 1992,1993 Engineering Design Research Center
 *
 * Author: Sean Levy (snl+@cmu.edu)
 *         n-dim Group
 *         Engineering Design Research Center
 *         Carnegie Mellon University
 *         5000 Forbes Ave / PGH, PA / 51221
 *
 *         Fax: (412) 268-5229
 *         Voice: (412) 268-5226
 */

/*
 * be.c,v 1.1 1992/07/31 20:12:05 snl Exp
 *
 * be.c,v
 * Revision 1.1  1992/07/31  20:12:05  snl
 * Massive checkin
 *
 */

static char rcsID[] = "be.c,v 1.1 1992/07/31 20:12:05 snl Exp";

#ifdef TK_INTERFACE
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/file.h>
#include <tk/tkInt.h>
#include <tcl/tcl.h>
#include <xow/xow.h>
#endif
#include <stdio.h>
#include <bos/bos.h>
#include <list.h>

#define DEFAULT_PROMPT "be>"
#define INIT_CMD "if [file exists .berc] {source .berc}"

main(argc,
     argv
     )
     int argc;
     char **argv;
{
  Tcl_Interp *interp;
  Bos_World *world;
  Tcl_CmdBuf buffer;
  char argc_str[20], *args;
  void be_InitInterp(), PQ_InitInterp(), ISIS_InitInterp();
#ifdef TK_INTERFACE
  int use_X_interface;

  use_X_interface = 0;
#endif /* TK_INTERFACE */
  interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
  Tcl_InitMemory(interp);
#endif /* TCL_MEM_DEBUG */
  Bos_InitializeBuiltins();
  world = Bos_InitInterp(interp, 0);
  Bos_CreateBuiltinObjects(world, interp);
  Tcl_SetVar(interp, "BEVERSION", BE_VERSION, TCL_GLOBAL_ONLY);
  Tcl_SetVar(interp, "BEPROMPT", DEFAULT_PROMPT, TCL_GLOBAL_ONLY);
  sprintf(argc_str, "%d", argc);
  Tcl_SetVar(interp, "argc", argc_str, TCL_GLOBAL_ONLY);
  args = Tcl_Merge(argc, argv);
  Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
  ckfree(args);
  be_InitInterp(world, interp)
  PQ_InitInterp(interp);
  ISIS_InitInterp(interp);
#ifdef TK_INTERFACE
  setup_tk(interp, argc, argv);
#endif /* TK_INTERFACE */
  result = Tcl_Eval(interp, INIT_CMD, 0, (char **) 0);
  if (result != TCL_OK) {
    printf("%s\n", interp->result);
    exit(1);
  }

  /*
   * Main Loop
   */

#ifdef TK_INTERFACE
  if (use_X_interface)
    Tk_MainLoop();
  else
#endif /* TK_INTERFACE */
    while (1)
      read_eval_print(stdin, TK_READABLE);
  exit(100); /* XXX never reached */
}

#ifdef TK_INTERFACE

static int
setup_tk(interp, argc, argv)
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
  char *p;
  int use_X_interface;

  use_X_interface = 0;
  p = strrchr(argv[0], '/');
  if (p != NULL)
    p++;
  else
    p = argv[0];
  if (!strcmp(p, "xbe"))\
    use_X_interface = 1;
  else if (getenv("BEUSETK") != (char *)0)
    use_X_interface = 1;
  if (use_X_interface) {
    Tk_Window w;
    Tk_3DBorder border;
    int DotCmd(), GeometryCmd(), LinetoCmd(), MapCmd(), MoveCmd(), MovetoCmd(),
        PolyCmd(), ResizeCmd(), OwnSelectionCmd();

    w = Tk_CreateMainWindow(interp, (char *)0, p);
    if (w == NULL) {
      fprintf(stderr, "%s: %s\n", argv[0], interp->result);
      exit(1);
    }
    Tk_SetClass(w, "Tk");
    if (Tk_ParseArgv(interp, w, &argc, argv, argTable, 0) != TCL_OK) {
      fprintf(stderr, "%s: %s\n", argv[0], interp->result);
      exit(1);
    }
    if (synchronize)
      XSynchronize(Tk_Display(w), True);
    Tk_GeometryRequest(w, default_width, default_height);
    border = Tk_Get3DBorder(interp, w, None, "#4eee94");
    if (border == NULL) {
      Tcl_Return(interp, (char *) NULL, TCL_STATIC);
      Tk_SetWindowBackground(w, WhitePixelOfScreen(Tk_Screen(w)));
    } else {
      Tk_SetBackgroundFromBorder(w, border);
    }
    XSetForeground(Tk_Display(w), DefaultGCOfScreen(Tk_Screen(w)),
		   BlackPixelOfScreen(Tk_Screen(w)));
    Tcl_CreateCommand(interp, "dot", DotCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "geometry", GeometryCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "lineto", LinetoCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "map", MapCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "move", MoveCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "moveto", MovetoCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "poly", PolyCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "resize", ResizeCmd, (ClientData) w,
		      (void (*)()) NULL);
    Tcl_CreateCommand(interp, "ownselection", OwnSelectionCmd, (ClientData) w,
		      (void (*)()) NULL);
#ifndef NO_XOW
    /* Xow */
    Xow_CreateCommands(interp, (ClientData)w);
#endif /* NO_XOW */
    ISIS_TkInit();
  }
}
	/* ARGSUSED */
int
  GeometryCmd(tkwin, interp, argc, argv)
Tk_Window tkwin;			/* Application window. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  Tk_Window window;
  int width, height;
  
  if (argc != 4) {
    sprintf(interp->result,
	    "wrong # args:  should be \"%.50s window width height\"",
	    argv[0]);
    return TCL_ERROR;
  }
  window = Tk_NameToWindow(interp, argv[1], tkwin);
  if (window == NULL) {
    return TCL_ERROR;
  }
  width = atoi(argv[2]);
  height = atoi(argv[3]);
  Tk_GeometryRequest(window, width, height);
  return TCL_OK;
}

/* ARGSUSED */
int
  ResizeCmd(tkwin, interp, argc, argv)
Tk_Window tkwin;			/* Application window. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  Tk_Window window;
  unsigned int width, height;
  
  if (argc != 4) {
    sprintf(interp->result,
	    "wrong # args:  should be \"%.50s window width height\"",
	    argv[0]);
    return TCL_ERROR;
  }
  window = Tk_NameToWindow(interp, argv[1], tkwin);
  if (window == NULL) {
    return TCL_ERROR;
  }
  width = atoi(argv[2]);
  height = atoi(argv[3]);
  if (!width)
    width = 1;
  if (!height)
    height = 1;
  Tk_ResizeWindow(window, width, height);
  return TCL_OK;
}

/* ARGSUSED */
int
  MapCmd(tkwin, interp, argc, argv)
Tk_Window tkwin;			/* Application window. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  Tk_Window window;
  
  if (argc != 2) {
    sprintf(interp->result,
	    "wrong # args:  should be \"%.50s window\"",
	    argv[0]);
    return TCL_ERROR;
  }
  window = Tk_NameToWindow(interp, argv[1], tkwin);
  if (window == NULL) {
    return TCL_ERROR;
  }
  Tk_MapWindow(window);
  return TCL_OK;
}

/* ARGSUSED */
int
  MoveCmd(tkwin, interp, argc, argv)
Tk_Window tkwin;			/* Application window. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  Tk_Window window;
  int x, y;
  
  if (argc != 4) {
    sprintf(interp->result,
	    "wrong # args:  should be \"%.50s window x y\"",
	    argv[0]);
    return TCL_ERROR;
  }
  window = Tk_NameToWindow(interp, argv[1], tkwin);
  if (window == NULL) {
    return TCL_ERROR;
  }
  x = atoi(argv[2]);
  y = atoi(argv[3]);
  Tk_MoveWindow(window, x, y);
  return TCL_OK;
}

/* ARGSUSED */
int
  DotCmd(dummy, interp, argc, argv)
ClientData dummy;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  int x, y;
  
  if (argc != 3) {
    sprintf(interp->result, "wrong # args: should be \"%.50s x y\"",
	    argv[0]);
    return TCL_ERROR;
  }
  x = strtol(argv[1], (char **) NULL, 0);
  y = strtol(argv[2], (char **) NULL, 0);
  XDrawPoint(Tk_Display(w), Tk_WindowId(w),
	     DefaultGCOfScreen(Tk_Screen(w)), x, y);
  return TCL_OK;
}

/* ARGSUSED */
int
  MovetoCmd(dummy, interp, argc, argv)
ClientData dummy;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  if (argc != 3) {
    sprintf(interp->result, "wrong # args: should be \"%.50s x y\"",
	    argv[0]);
    return TCL_ERROR;
  }
  x = strtol(argv[1], (char **) NULL, 0);
  y = strtol(argv[2], (char **) NULL, 0);
  return TCL_OK;
}
/* ARGSUSED */
int
  LinetoCmd(dummy, interp, argc, argv)
ClientData dummy;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  int newX, newY;
  
  if (argc != 3) {
    sprintf(interp->result, "wrong # args: should be \"%.50s x y\"",
	    argv[0]);
    return TCL_ERROR;
  }
  newX = strtol(argv[1], (char **) NULL, 0);
  newY = strtol(argv[2], (char **) NULL, 0);
  XDrawLine(Tk_Display(w), Tk_WindowId(w),
	    DefaultGCOfScreen(Tk_Screen(w)), x, y, newX, newY);
  x = newX;
  y = newY;
  return TCL_OK;
}

void
  LostSelection(name)
char *name;
{
  printf("Window %s lost selection.\n", name);
}

/* ARGSUSED */
int
  PolyCmd(tkwin, interp, argc, argv)
Tk_Window tkwin;			/* Not used. */
Tcl_Interp *interp;			/* Current interpreter. */
int argc;				/* Number of arguments. */
char **argv;			/* Argument strings. */
{
  GC gc;
  XColor *colorPtr;
  XGCValues values;
  Tk_3DBorder border;
  XPoint points[50], *pointPtr;
  int i, numPoints, width, foo;
  Tk_Window tkwin2;
  
  if ((argc < 8) || (argc > 50) || (argc & 01)) {
    sprintf(interp->result,
	    "wrong # args:  should be \"%.50s window color width x1 y1 x2 y2 ...\"",
	    argv[0]);
    return TCL_ERROR;
  }
  tkwin2 = Tk_NameToWindow(interp, argv[1], tkwin);
  if (tkwin2 == NULL) {
    return TCL_ERROR;
  }
  colorPtr = Tk_GetColor(interp, tkwin2, (Colormap) None,
			 Tk_GetUid(argv[2]));
  if (colorPtr == NULL) {
    return TCL_ERROR;
  }
  values.foreground = colorPtr->pixel;
  gc = Tk_GetGC(tkwin2, GCForeground, &values);
  border = Tk_Get3DBorder(interp, tkwin2, (Colormap) None,
			  Tk_GetUid(argv[2]));
  if (border == NULL) {
    return TCL_ERROR;
  }
  if (Tcl_GetInt(interp, argv[3], &width) != TCL_OK) {
    return TCL_ERROR;
  }
  for (i = 4, pointPtr = points; i < argc; i += 2, pointPtr++) {
    if (Tcl_GetInt(interp, argv[i], &foo) != TCL_OK) {
      return TCL_ERROR;
    }
    pointPtr->x = foo;
    if (Tcl_GetInt(interp, argv[i+1], &foo) != TCL_OK) {
      return TCL_ERROR;
    }
    pointPtr->y = foo;
  }
  numPoints = (argc-4)/2;
  XFillPolygon(Tk_Display(tkwin2), Tk_WindowId(tkwin2), gc, points,
	       numPoints, Nonconvex, CoordModeOrigin);
  Tk_Draw3DPolygon(Tk_Display(tkwin2), Tk_WindowId(tkwin2), border,
		   points, numPoints, width, 1);
  return TCL_OK;
}

typedef struct {
  Tcl_Interp *interp;
  char *command;
} LostSelectionClosure;

void
  InvokeTclLostSelection(clientData)
ClientData clientData;
{
  LostSelectionClosure *closure = (LostSelectionClosure *)clientData;
  
  Tcl_Eval(closure->interp, closure->command, 0, NULL);
  ckfree(closure->command);
  ckfree(closure);
}

int
  OwnSelectionCmd(clientData, interp, argc, argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char **argv;
{
  Tk_Window interpWin = (Tk_Window) clientData;
  Tk_Window tkwin; /* window which will own the selection */
  LostSelectionClosure *closure;
  
  if (argc != 3){
    Tcl_AppendResult(interp,
		     "wrong # of args: should be \"ownselection window lostselectioncmd\"",
		     (char *)0);
    return TCL_ERROR;
  }
  
  tkwin = Tk_NameToWindow(interp, argv[1], interpWin);
  if (tkwin == (Tk_Window)0){
    Tcl_AppendResult(interp,
		     "bad window path name \"", argv[1],"\".",
		     (char *)0);
    return TCL_ERROR;
  }
  
  closure = (LostSelectionClosure *)ckalloc(sizeof(LostSelectionClosure));
  closure->interp = interp;
  closure->command = (char *)ckalloc(sizeof(char)*
				     (strlen(argv[1]) + strlen(argv[2]) + 2));
  sprintf(closure->command, "%s %s", argv[2], argv[1]);
  Tk_OwnSelection(tkwin, InvokeTclLostSelection, (ClientData)closure);
  return TCL_OK;
}

#endif /* TK_INTERFACE */

static void
read_eval_print(f, mask)
     ClientData f;
     int mask;
{
  Tcl_Interp *interp;
  Tcl_CmdBuf buffer;
  char *cmd, line[1000];
  int got_partial;
  file_info *f_info, *get_info();

  if (!(mask & TK_READABLE))
    return;

  f_info = get_info(f);
  buffer = f_info->buf;
  got_partial = f_info->partial;
  interp = f_info->interp;

  clearerr(f);
  if (!got_partial && !(f_info->no_prompt)) {
    char *p;
    
    p = Tcl_GetVar(interp, "BEPROMPT", TCL_GLOBAL_ONLY);
    if (p != (char *)0) {
      fputs(prompt_string(interp), stdout);
      fflush(stdout);
    }
  }
  if (fgets(line, sizeof(line), f) == NULL) {
    if (!got_partial) {
      if (fileno(f) == 0)
	exit(0);
      else if (f_info->tk) {
	forget_input_source(f_info);
	return;
      }
    }
    line[0] = 0;
  }
  cmd = Tcl_AssembleCmd(buffer, line);
  if (cmd == NULL) {
    got_partial = f_info->partial = 1;
    continue;
  }
  
  got_partial = f_info->partial = 0;
  result = Tcl_RecordAndEval(interp, cmd, 0);
  if (result == TCL_OK) {
    if (*interp->result != 0) {
      printf("%s\n", interp->result);
    }
  } else {
    if (result == TCL_ERROR) {
      printf("Error");
    } else {
      printf("Error %d", result);
    }
    if (*interp->result != 0)
      printf(": %s\n", interp->result);
    else
      printf("\n");
  }
}
