/* Bos_Hook.c - C/Tcl hook functions for CMethods and Slots
 *
 * /afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Hook.c,v 1.1.1.1 1992/05/08 19:45:31 snl Exp
 *
 * HISTORY
 *
 * Bos_Hook.c,v
 * Revision 1.1.1.1  1992/05/08  19:45:31  snl
 * bos 1.2
 *
 * Revision 1.1  92/03/06  22:02:56  snl
 * Initial revision
 * 
 * Revision 1.2  92/01/27  16:19:21  snl
 * Port to new TCL
 * 
 * Revision 1.1  91/12/16  20:14:41  snl
 * Initial revision
 * 
 */

#ifndef lint
static char *_RCSId =
 "/afs/cs/project/edrc/ndim/source/bos/libbos/Bos_Hook.c,v 1.1.1.1 1992/05/08 19:45:31 snl Exp";
#endif /* lint */

#include "bosInt.h"
#include "bos.h"

typedef struct _Hook {
  List_Links links;
  char *name;
  _VoidPtr hook;
} Hook;

typedef char *(*CharPtrFn)();
typedef _VoidPtr (*VoidPtrFn)();
typedef void (*VoidFn)();

typedef struct _SlotHook {
  List_Links links;
  char *name;
  Bos_Slot_Subtype type;
  CharPtrFn print;
  _VoidPtr print_arg;
  VoidFn freefn;
  _VoidPtr free_arg;
  VoidPtrFn parse;
  _VoidPtr parse_arg;
  VoidPtrFn copy;
  _VoidPtr copy_arg;
} SlotHook;

static Hook *hooks = (Hook *)0;
static SlotHook *shooks = (SlotHook *)0;
static Bos_Slot_Subtype highestHook = 0;

static SlotHook *findSlotHook _ARGS_((Bos_Slot_Subtype subtype));
static SlotHook *findSlotHookByName _ARGS_((char *name));

int Bos_HookCMethod(name, hook)
     char *name;
     _VoidPtr hook;
{
  Hook *h;

  h = (Hook *)ckalloc(sizeof(Hook));
  List_InitElement((List_Links *)h);
  h->name = (char *)ckalloc(strlen(name) + 1);
  strcpy(h->name, name);
  h->hook = hook;
  if (hooks == (Hook *)0) {
    hooks = (Hook *)ckalloc(sizeof(Hook));
    List_Init((List_Links *)hooks);
  }
  List_Insert(h, LIST_ATREAR(hooks));
  return BOS_OK;
}

char *Bos_GetCMethodName(ptr)
     _VoidPtr ptr;
{
  int found = 0;
  Hook *h;
  List_Links *hooks_l, *h_l;

  if (hooks == (Hook *)0)
    return (char *)0;
  hooks_l = (List_Links *)hooks;
  LIST_FORALL(hooks_l, h_l) {
    h = (Hook *)h_l;
    if (h->hook == ptr) {
      found = 1;
      break;
    }
  }
  return found? h->name: (char *)0;
}

ANYTHING *
Bos_GetCMethodPointer(name)
     char *name;
{
  int found = 0;
  Hook *h;
  List_Links *hooks_l, *h_l;

  if (hooks == (Hook *)0)
    return (ANYTHING *)0;
  hooks_l = (List_Links *)hooks;
  LIST_FORALL(hooks_l, h_l) {
    h = (Hook *)h_l;
    if (!strcmp(h->name, name)) {
      found = 1;
      break;
    }
  }
  return found? (ANYTHING *)(h->hook): (ANYTHING *)0;
}

void
Bos_UnhookCMethod(name)
     char *name;
{
  int found = 0;
  Hook *h;
  List_Links *hooks_l, *h_l;

  if (hooks == (Hook *)0)
    return;
  hooks_l = (List_Links *)hooks;
  LIST_FORALL(hooks_l,h_l) {
    h = (Hook *)h_l;
    if (!strcmp(h->name, name)) {
      found = 1;
      break;
    }
  }
  if (found) {
    List_Remove(h_l);
    ckfree(h->name);
    ckfree(h);
  }
}

Bos_Slot_Subtype Bos_DefineCSlotType(name, print, print_arg, freefn, free_arg,
                                     parse, parse_arg, copy, copy_arg)
     char *name;
     _VoidPtr print;
     _VoidPtr print_arg;
     _VoidPtr freefn;
     _VoidPtr free_arg;
     _VoidPtr parse;
     _VoidPtr parse_arg;
     _VoidPtr copy;
     _VoidPtr copy_arg;
{
  SlotHook *s;

  s = findSlotHookByName(name);
  if (s != (SlotHook *)0)
    return Bos_INVALID_SLOT_SUBTYPE;
  s = (SlotHook *)ckalloc(sizeof(SlotHook));
  List_InitElement((List_Links *)s);
  s->name = (char *)ckalloc(strlen(name) + 1);
  strcpy(s->name, name);
  s->type = ++highestHook;
  s->print = (CharPtrFn)print;
  s->print_arg = print_arg;
  s->freefn = (VoidFn)freefn;
  s->free_arg = free_arg;
  s->parse = (VoidPtrFn)parse;
  s->parse_arg = parse_arg;
  s->copy = (VoidPtrFn)copy;
  s->copy_arg = copy_arg;
  if (shooks == (SlotHook *)0) {
    shooks = (SlotHook *)ckalloc(sizeof(SlotHook));
    List_Init((List_Links *)shooks);
  }
  List_Insert(s, LIST_ATREAR(shooks));
  return s->type;
}

Bos_Slot_Subtype Bos_GetCSlotType(name)
     char *name;
{
  SlotHook *s;

  s = findSlotHookByName(name);
  return s? s->type: Bos_INVALID_SLOT_SUBTYPE;
}

char *Bos_GetCSlotTypeName(subtype)
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;

  s = findSlotHook(subtype);
  return s? s->name: (char *)0;
}

void Bos_UndefineCSlotType(subtype)
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;

  s = findSlotHook(subtype);
  if (s != (SlotHook *)0) {
    List_Remove((List_Links *)s);
    ckfree(s->name);
    ckfree(s);
  }
}

char *Bos_GetCSlotString(value, subtype)
     _VoidPtr value;
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;
  char *str;

  s = findSlotHook(subtype);
  if (s == (SlotHook *)0)
    str = (char *)0;
  else
    str = (*s->print)(value, s->print_arg, subtype);
  return str;
}

ANYTHING *
Bos_ParseCSlotString(string, subtype)
     char *string;
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;
  _VoidPtr val;

  s = findSlotHook(subtype);
  if (s == (SlotHook *)0)
    val = (ANYTHING *)0;
  else
    val = (*s->parse)(string, s->parse_arg, subtype);
  return (ANYTHING *)val;
}

void Bos_FreeCSlotValue(value, subtype)
     _VoidPtr value;
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;

  s = findSlotHook(subtype);
  if (s != (SlotHook *)0)
    (*s->freefn)(value, s->free_arg, subtype);
}

ANYTHING *
Bos_CopyCSlotValue(value, subtype)
     _VoidPtr value;
     Bos_Slot_Subtype subtype;
{
  SlotHook *s;
  _VoidPtr val;

  s = findSlotHook(subtype);
  if (s == (SlotHook *)0)
    val = (ANYTHING *)0;
  else
    val = (*s->copy)(value, s->copy_arg, subtype);
  return (ANYTHING *)val;
}

static SlotHook *findSlotHook(subtype)
     Bos_Slot_Subtype subtype;
{
  List_Links *shooks_l, *s_l;
  SlotHook *s;
  int found = 0;

  if (shooks == (SlotHook *)0)
    return (SlotHook *)0;
  shooks_l = (List_Links *)shooks;
  LIST_FORALL(shooks_l, s_l) {
    s = (SlotHook *)s_l;
    if (s->type == subtype) {
      found = 1;
      break;
    }
  }
  return found? s: (SlotHook *)0;
}

static SlotHook *findSlotHookByName(name)
     char *name;
{
  List_Links *shooks_l, *s_l;
  SlotHook *s;
  int found = 0;

  if (shooks == (SlotHook *)0)
    return (SlotHook *)0;
  shooks_l = (List_Links *)shooks;
  LIST_FORALL(shooks_l, s_l) {
    s = (SlotHook *)s_l;
    if (!strcmp(name, s->name)) {
      found = 1;
      break;
    }
  }
  return found? s: (SlotHook *)0;
}
