/* bosInt.h - internal header */

/* Copyright (C) 1992 Engineering Design Research Center
 */

#ifndef __bosInt_H__
#define __bosInt_H__

#include <stdlib.h>
#include <list.h>
#include <tclHash.h>
#include <tcl.h>
#include "bosMacros.h"
#include "bos.h"

#ifndef _ALREADY_HAVE_VoidPtr
typedef void *_VoidPtr;
#endif /* _ALREADY_HAVE_VoidPtr */

typedef struct _Bos_Slot {
  char *name;			/* The name of the slot;
				   necessary because when we traverse
				   via the Hash routines, we don't
				   get the key. */
  _VoidPtr value;		/* The value. */
  Bos_Slot_Type type;		/* One of the Bos_SLOT_xxx values */
  Bos_Slot_Pri pri;		/* Priority of this slot;
                                   If the slot is not an OBJECT slot,
				   then this can be used for different
				   purposes. In the case of C-typed
				   slots, this is the slot type subcode. */
} Bos_Slot;

#ifdef _EVEN_SIZED_STRUCTS
typedef unsigned short Bos_Method_Flags;
#else
typedef unsigned char Bos_Method_Flags;	/* Flag bits for a method */
#endif

typedef struct _Bos_Method {
  char *body;			/* String containing the method body.
				   This is actually a Tcl list with
				   two parts, the formals and the code,
				   just as in normal TclProcs. */
  char *proc_name;		/* Intern'ed procedure name. This is
				   guaranteed to be unique per world. */
  Bos_Method_Flags flags;	/* Flag bits:
				    METHOD_INTERNED means that proc_name
				   has a valid pointer and that the proc
				   is defined.
				    METHOD_CHANGED means that either the
				   body or the formals have been changed
				   via SetSlot. SetSlot just sets this
				   bit and returns, leaving the business
				   of re-interning to Send:invokeMethod()
				   when it notices that CHANGED is set and
				   INTERNED is as well. */
} Bos_Method;

#define Bos_METHOD_INTERNED 0x01
#define Bos_METHOD_CHANGED 0x02

#ifdef _EVEN_SIZED_STRUCTS
typedef unsigned short Bos_Object_Flags;
#else
typedef unsigned char Bos_Object_Flags;
#endif

struct _Bos_Object {
  char *name;			/* Name of the object. */
  Bos_Object_Flags flags;	/* Flag bits for object. These are for
				   use by internal Bos routines only, and
				   are guaranteed to not be defined. */
  Tcl_HashTable *slots;		/* Slots of the object, stored as
				   a hash table. */
};

struct _Bos_World {
  Tcl_HashTable *objects;
  Tcl_Interp *methods;
};

#define Bos_Objects(world) ((world)->objects)
#define Bos_Methods(world) ((world)->methods)

/* Random definitions */

#define Bos_USE_DYNAMIC_RETURN 200

/* Semi-exported functions */

Bos_Slot *
_BosFindSlot _ARGS_((
	Bos_Object *obj,
	char *slot_name
));

#endif /* __bosInt_H__ */
