#
#------------------------------------------------------------------------------
#  Copyright (c) 1993-1995 European Synchrotron Radiation Facility
#
#  Permission to use, copy, modify, and distribute this software and its
#  documentation for any purpose and without fee is hereby granted, provided
#  that the "Terms and Conditions of Distribution", given in the documentation
#  to this software, are applicable and the above copyright message appears in
#  each copy.
#
#------------------------------------------------------------------------------
#
#  Parts of this file where copied from the "Config.mk"-File of the TclX
#  distribution.
#
#
#  Config.mk --
#
#  Master configuration file for CTAXT.  This should be the only file you have
#  to modify to get CTAXT to work. It is used to set attributes that configure
#  can't figure out and to override certain attributes set by configure.
# 
#  All the values in this directory are set to reasonable defaults. You might
#  want to tune them to your taste.  You may set the value of "CC" and "CFLAGS"
#  in the file or on the make command line or set them.  For example:
#
#       make -k CC=gcc CFLAGS=-O
#


#------------------------------------------------------------------------------
#              READ THIS FIRST: FILE PATH SPECIFICATION RULES.
#------------------------------------------------------------------------------
# All paths to files outside of the distribution MUST follow these rules.
# The rules make it easy to specify locations of files either relative to
# the source or build directories or as absolute directories.  If these
# rules are not followed, it will not build.  All values are defaulted to
# reasonable locations.  If UCB Tcl and Tk are in directories that are
# siblings of the CTAXT source directory, things will probably work just fine.
#
# File paths MUST be one of:
#
#   o Absolute paths (starting with /), e.g.  /usr/local/lib/libtcl.a
#   o Paths relative to the source directory make macro ${srcdir}, e.g.
#     ${srcdir}/../tk3.6
#   o Paths relative to the make macro ${prefix} or ${exec_prefix}
#
#------------------------------------------------------------------------------


#------------------------------------------------------------------------------
# Definition, whether to build CTAXT with extended Tcl/Tk or just Tcl/Tk
#
# Set to either CTAXT (for just Tcl/Tk) or CTAXTX (for extended Tcl/Tk)
#

CTAXTVERSION=CTAXT
#CTAXTVERSION=CTAXTX


#------------------------------------------------------------------------------
# The directory to install the libctaxt.a into

CTAXT_LIBDIR=${exec_prefix}/lib


#------------------------------------------------------------------------------
# The directory the ctaxt.h files goes into.

CTAXT_INCLUDEDIR=${prefix}/include


#------------------------------------------------------------------------------
# The directories where to install the man pages
#
# Top-level directory for manual entries:

MAN_DIR =       ${prefix}/man


#------------------------------------------------------------------------------
# Directory in which to install the introduction to CTAXT

MAN1_DIR =      ${MAN_DIR}/man1


#------------------------------------------------------------------------------
# Directory in which to install manual entries for the CTAXT C library:

MAN3_DIR =      ${MAN_DIR}/man3


#------------------------------------------------------------------------------
# UCB Tcl source distribution directory and UCB Tk source distribution 
# directory. If wish and/or wishx is located in one of the paths given
# in your PATH environment variable, there should be no need to set these
# variables.


#TCL_UCB=${srcdir}/../tcl7.3
#TK_UCB=${srcdir}/../tk3.6


#------------------------------------------------------------------------------
# UCB Extended Tcl source distribution directory. If wish and/or wishx is 
# located in one of the paths given in your PATH environment variable, there 
# should be no need to set the variable.


#TCLX_UCB=${srcdir}/../tclX7.3a/src


#------------------------------------------------------------------------------
# Definition, where your Tk-Script-Library is installed. The path normally
# differs for the normal and the extended version of CTAXT. Define TK_LIB, if
# you build the normal version of CTAXT and TKX_LIB, if you build the extended
# version. However, if wish and/or wishx is located in one of the paths given
# in your PATH environment variable, there should be no need to set these
# variables.
#

#TK_SCRIPTLIB=
#TKX_SCRIPTLIB=


#------------------------------------------------------------------------------
# Definition of the compiler, ar and ranlib program you wish to use.
#

#CC=cc
AR=ar
#RANLIB=ranlib


#------------------------------------------------------------------------------
# Additional flags to pass to the compiler for each compilation
#

CFLAGS=


#------------------------------------------------------------------------------
# X is often in strange places, override what configure figured out if
# its wrong.

#XINCLUDES=-I/usr/somewhere/include


#------------------------------------------------------------------------------
# EXtra flags:
#   o XCFLAGS - Extra compiler flags on all compiles and links
#   o XLDFLAGS - Extra compiler flags to specify at link time.
#   o XLDLIBS - Extra libraries to use at link time.

XCFLAGS=
