# button.tcl --
#
# This file defines the default bindings for Tk label, button,
# checkbutton, and radiobutton widgets.
#
# @(#) button.tcl 1.14 94/12/17 16:05:11
#
# Copyright (c) 1992-1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.
#

# tkButtonBind --
# This procedure is invoked the first time the mouse enters a button,
# checkbutton, or radiobutton, or any one of these widgets receives
# the input focus.  It creates all of the class bindings for the widgets.
#
# Arguments:
# w -		The widget that was just entered or just received
#		the input focus.
# event -	Indicates which event caused the procedure to be invoked
#		(Enter or FocusIn).  It is used so that we can carry out
#		the functions of that event in addition to setting up
#		bindings.

proc tkButtonBind {w {event {}}} {
    # Standard Motif bindings:

    bind Button <FocusIn> {}
    bind Button <space> {
	tkButtonInvoke %W
    }

    bind Checkbutton <FocusIn> {}
    bind Checkbutton <space> {
	tkCheckRadioInvoke %W
    }

    bind Radiobutton <FocusIn> {}
    bind Radiobutton <space> {
	tkCheckRadioInvoke %W
    }
}

# tkButtonInvoke --
# The procedure below is called when a button is invoked through
# the keyboard.  It simulate a press of the button via the mouse.
#
# Arguments:
# w -		The name of the widget.

proc tkButtonInvoke w {
    if {[$w cget -state] != "disabled"} {
#	set oldRelief [$w cget -relief]
#	set oldState [$w cget -state]
#	$w configure -state active -relief sunken
#	update idletasks
#	after 100
#	$w configure -state $oldState -relief $oldRelief
	uplevel #0 [list $w invoke]
    }
}

# tkCheckRadioInvoke --
# The procedure below is invoked when the mouse button is pressed in
# a checkbutton or radiobutton widget, or when the widget is invoked
# through the keyboard.  It invokes the widget if it
# isn't disabled.
#
# Arguments:
# w -		The name of the widget.

proc tkCheckRadioInvoke w {
    if {[$w cget -state] != "disabled"} {
	uplevel #0 [list $w invoke]
    }
}
