# ctk.tcl --
#
# Initialization script normally executed in the interpreter for each
# CTk-based application.  Arranges class bindings for widgets.
#
# @(#) $Header: /usrs/cvs/root/ctk/library/ctk.tcl,v 1.1.1.1 1995/03/12 16:28:08 andrewm Exp $
#
# Copyright (c) 1992-1994 The Regents of the University of California.
# Copyright (c) 1994 Sun Microsystems, Inc.
#
# See the file "license.terms" for information on usage and redistribution
# of this file, and for a DISCLAIMER OF ALL WARRANTIES.

# Insist on running with compatible versions of Tcl and Tk.

scan [info tclversion] "%d.%d" a b
if {$a != 7} {
    error "wrong version of Tcl loaded ([info tclversion]): need 7.x"
}
scan $tk_version "%d.%d" a b
if {($a != 4) || ($b < 0)} {
    error "wrong version of Tk loaded ($tk_version): need 4.0 or later"
}
if {$tk_port != "curses"} {
    error "wrong port of Tk loaded ($tk_port): need curses"
}
unset a b

# Add Tk's directory to the end of the auto-load search path:

lappend auto_path $tk_library

# Turn off strict Motif look and feel as a default.

set tk_strictMotif 0

# ----------------------------------------------------------------------
# Class bindings for various flavors of button widgets.
# ----------------------------------------------------------------------

bind Label <FocusIn> {
    tk_focusContinue %W
}
bind Button <FocusIn> {tkButtonBind %W FocusIn}
bind Checkbutton <FocusIn> {tkButtonBind %W FocusIn}
bind Radiobutton <FocusIn> {tkButtonBind %W FocusIn}

# ----------------------------------------------------------------------
# Class bindings for entry widgets.
# ----------------------------------------------------------------------

bind Entry <FocusIn> {tkEntryBind FocusIn}

# ----------------------------------------------------------------------
# Class bindings for listbox widgets.
# ----------------------------------------------------------------------

bind Listbox <FocusIn> {tkListboxBind FocusIn}

# ----------------------------------------------------------------------
# Class bindings for menubutton and menu widgets.
# ----------------------------------------------------------------------

bind Menubutton <FocusIn> {tkMenuBind %W FocusIn}
bind Menu <FocusIn> {tkMenuBind %W FocusIn}
bind all <F1> {
    tkFirstMenu %W
}

# ----------------------------------------------------------------------
# Class bindings for menubar (special frames) widgets.
# ----------------------------------------------------------------------

bind Menubar <FocusIn> {
    tk_focusContinue %W
}

# ----------------------------------------------------------------------
# Class bindings for scrollbar widgets.
# ----------------------------------------------------------------------

bind Scrollbar <FocusIn> {
    tk_focusContinue %W
}

# ----------------------------------------------------------------------
# Class bindings for text widgets. $tkPriv(selectMode) holds one of
# "char", "word", or "line" to indicate which selection mode is active.
# ----------------------------------------------------------------------

bind Text <FocusIn> {tkTextBind FocusIn}

# ----------------------------------------------------------------------
# Default bindings for keyboard traversal.
# ----------------------------------------------------------------------

bind all <Tab> {tk_focusNext %W}
bind all <Shift-Tab> {tk_focusPrev %W}

# tkScreenChanged --
# This procedure is invoked by the binding mechanism whenever the
# "current" screen is changing.  The procedure does two things.
# First, it uses "upvar" to make global variable "tkPriv" point at an
# array variable that holds state for the current display.  Second,
# it initializes the array if it didn't already exist.
#
# Arguments:
# screen -		The name of the new screen.

proc tkScreenChanged screen {
    set disp [file rootname $screen]
    uplevel #0 upvar #0 tkPriv.$disp tkPriv
    global tkPriv
    if [info exists tkPriv] {
	set tkPriv(screen) $screen
	return
    }
    set tkPriv(afterId) {}
    set tkPriv(buttons) 0
    set tkPriv(buttonWindow) {}
    set tkPriv(dragging) {}
    set tkPriv(focus) {}
    set tkPriv(focusContinue) 0
    set tkPriv(focusDir) next
    set tkPriv(focusOrigin) {}
    set tkPriv(grab) {}
    set tkPriv(grabType) {}
    set tkPriv(inMenubutton) {}
    set tkPriv(initMouse) {}
    set tkPriv(mouseMoved) 0
    set tkPriv(popup) {}
    set tkPriv(postedMb) {}
    set tkPriv(screen) $screen
    set tkPriv(selectMode) char
    set tkPriv(window) {}
}

# Do initial setup for tkPriv, so that it is always bound to something
# (otherwise, if someone references it, it may get set to a non-upvar-ed
# value, which will cause trouble later).

tkScreenChanged [winfo screen .]

# grab --
#
#	Cheap simulation of Tk's grab.  Currently - a grab has
#	no effect on CTk - this will change if I add a window
#	manager.
#
proc grab {option args} {
    global tkPriv

    if {! [winfo exists $tkPriv(grab)]} {
	set tkPriv(grab) {}
    }
    switch -exact -- $option {
	current { return $tkPriv(grab) }
	release {
	    if {$args == $tkPriv(grab)}  {
	    	set tkPriv(grab) {}
	    }
	    return {}
	}
	status  {
	    if {$args == $tkPriv(grab)} {
		return $tkPriv(grabType)
	    } else {
		return none
	    }
	}
	set     {
	    set option [lindex $args 0]
	    set args [lrange $args 1 end]
	    # Falls through ...
	}
    }
    if {$option == "-global"} {
	set tkPriv(grab) $args
	set tkPriv(grabType) global
    } else {
	set tkPriv(grab) $option
	set tkPriv(grabType) local
    }
}

# wm --
#
#	Cheap simulation of Tk's wm.
#
proc wm {option window args} {
    switch -exact -- $option {
	title {
	    if {$args == ""} {
		return $window cget -title
	    }
	    $window configure -title [lindex $args 0]
	}
	transient { }
	overrideredirect {return 0 }
    }
}

