/*
 *  -----------------------------------------------------------------
 *    Copyright 1993 D.I.S. - Universita` di Pavia - Italy
 *  -----------------------------------------------------------------
 *
 *  Permission to  use,  copy,   modify,   distribute  this  software
 *  and  its  documentation for any purpose is hereby granted without
 *  fee, provided that the above copyright  notice   appear   in  all
 *  copies   and  that both that copyright notice and this permission
 *  notice appear in supporting documentation, and that the  name  of
 *  D.I.S.   not  be  used  in advertising or publicity pertaining to
 *  distribution of the software without specific, written prior per-
 *  mission.   D.I.S.  makes no representations about the suitability
 *  of this software for any purpose.  It is provided "as is" without
 *  express or implied warranty.
 *
 *  D.I.S. DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, IN-
 *  CLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
 *  NO EVENT SHALL D.I.S.  BE LIABLE FOR  ANY  SPECIAL,  INDIRECT  OR
 *  CONSEQUENTIAL  DAMAGES  OR  ANY DAMAGES WHATSOEVER RESULTING FROM
 *  LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION  OF  CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNEC-
 *  TION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * Modified to work with HP/UX 9.X Operating System.
 * Michael Moore (mdm@cis.ohio-state.edu)
 * December 24th, 1993
 */

#include <tcl.h>
#include <dl.h>
#include <errno.h>


int dl_load(Tcl_Interp *interp, char *path, char *initFun)
{
    shl_t xlib;
    int (*install)(Tcl_Interp *);
    int i;

	/*
	 *	If the named library does not exist, if it's not loadable or if
	 *	it does not define the named install proc, report an error
	 */
    xlib = shl_load(path, BIND_IMMEDIATE | BIND_VERBOSE, 0L);
    if (xlib == (shl_t) NULL)  {
      Tcl_AppendResult(interp, "Unable to load shared library : ",
		       strerror(errno), (char *) NULL);
      return TCL_ERROR;
    }
    i = shl_findsym(&xlib, initFun, TYPE_PROCEDURE, &install);
    if (i == -1) { 
      Tcl_AppendResult(interp, "Unable to find needed symbol ",
		       initFun, ": ", strerror(errno), (char *) NULL);
      return TCL_ERROR;
    }      
    if (install == NULL) {
      Tcl_AppendResult(interp, "Unable to find needed symbol ",
		       initFun, ": Error type unknown.", (char *) NULL);
      return TCL_ERROR;
    }
    /*	
     *	Try to install the extension and report success or failure
     */
    return (*install)(interp);
}

