/* command.h - definitions for expect commands
***************************************************************************** 
expecTerm version 1.0 beta
Mark Weissman
Christopher Matheus
Copyright 1992 by GTE Laboratories Incorporated.

Portions of this work are in the public domain.  Permission to use,
copy, modify, and distribute this software and its documentation for
any purpose and without fee is hereby granted, provided that the above
copyright notice appear in all copies and that both the copyright
notice and warranty disclaimer appear in supporting documentation, and
that the names of GTE Laboratories or any of their entities not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.

GTE disclaims all warranties with regard to this software, including
all implied warranties of merchantability and fitness for a particular
purpose, even if GTE Laboratories Incorporated knows about the
purpose.  In no event shall GTE be liable for any special, indirect or
consequential damages or any damages whatsoever resulting from loss of
use, data or profits, whether in an action of contract, negligence or
other tortuous action, arising out of or in connection with the use or
performance of this software.

This code is based on and may include parts of Don Libes' expect code:
  expect written by: Don Libes, NIST, 2/6/90
  Design and implementation of expect was paid for by U.S. tax
  dollars.  Therefore it is public domain.  However, the author and NIST
  would appreciate credit if this program or parts of it are used.
******************************************************************************


Written by: Don Libes, NIST, 2/6/90
Modified by: Mark Weissman 9/92

Design and implementation of this program was paid for by U.S. tax
dollars.  Therefore it is public domain.  However, the author and NIST
would appreciate credit if this program or parts of it are used.
*/

void tcl_error();
int getmaster();
char *get_var();
double get_timeout();	/* MDW: Mon Jun 22 13:25:47 1992 */
extern int master;
struct f *update_master();
extern int default_match_max;

extern int loguser;	/* shared by cmdLoguser, cmdExpect and cmdSpawn */

/* special version of log for non-null-terminated strings which */
/* never need printf-style formatting. */
#define logn(buf,length)  { \
			  if (logfile) fwrite(buf,1,length,logfile); \
			  if (debugfile) fwrite(buf,1,length,debugfile); \
			  }

#define USER_SPAWN_ID		0
#define USER_SPAWN_ID_LIT	"0"
#define is_user(x)	(x == 0)

/* fd flags */
#define FD_VALID	0x1	/* valid entry in fds table */
#define FD_CLOSED	0x2	/* has been closed */
#define FD_USER		0x4	/* stdin or stdout */
#define FD_SYSWAITED	0x8	/* wait() has been called */
#define FD_USERWAITED	0x10	/* expect's wait has been called */

/* each process is associated with a 'struct f'.  An array of these ('fs') */
/* keeps track of all processes.  They are indexed by the true fd to the */
/* master side of the pty */
struct f {
	int pid;
	char *buffer;	/* input buffer */
	char *lower;	/* input buffer in lowercase */
	int size;	/* current size of data */
	int msize;	/* size of buffer */
	int umsize;	/* user view of size of buffer */
	int flags;	/* see above */
	int wait;	/* raw status from wait() */
	int printed;	/* # of characters written to stdout (if logging on) */
			/* but not actually returned via a match yet */
	double quiet_total_start;
	double quiet_after_noise_start;
	double quiet_start;
	double quiet_end;
};
extern struct f *fs;

struct f *fd_to_f();
int f_adjust();
