#ifndef EVENT_H
#define EVENT_H

class client;
class widget;
extern "C" union XEvent;
class kit;

// extern event* dummy_event;  // zero

class event : public handler {

protected:
void obsolete(char*s ="") {
cerr << "OBSOLETE " << " replace by event::ev-> " << s << endl;
}

public:
event() : secondary(0) { ev = 0; next = 0; }
event(event* p) : ev(p), secondary(1) { next = 0; }

virtual ~event() { if (next) delete next; }

virtual int dispatch(kit* tk_, int argc_, char* argv_[]) {
	tk = tk_; argc = argc_; argv = argv_;
	operator()();
	update();
	return OK;
	}

virtual int operator()() { return handler::operator()(); }

virtual int type() { if (ev) return ev->type(); else return 2; } /*press*/
virtual char* name() { if (ev) return ev->name(); else return "anonymous"; }
virtual void trace() { if (ev) ev->trace(); }

virtual int no() { if (ev) return ev->no(); else return 0; }
virtual char* id() { if (ev) return ev->id(); else return "anonymous"; }

virtual int x() { if (ev) return ev->x(); else return 0; }
virtual int y() { if (ev) return ev->y(); else return 0; } 

virtual int button(int i = 0) { if (ev) return ev->button(i); else return 0; }
virtual int buttonup(int i = 0) { if (ev) return ev->buttonup(i); else return 0; }

virtual int keycode() { if (ev) return ev->keycode(); else return 0; }

virtual int buttonevent(int i = 0) { if (ev) return buttonevent(i); else return 0; }
virtual int keyevent() { if (ev) return keyevent(); else return 0; }

virtual int motion() { if (ev) return ev->motion(); else return 0; }
virtual void motion( event& ) { }

event* ev;


// will become obsolete
struct callback* callback() { obsolete("callback"); return 0; }
class widget* widget() { obsolete("widget"); return 0; }
client* data() { obsolete("data"); return 0; }

union XEvent* XEvent() { obsolete("XEvent"); return 0; }

// to effect multiple events (advanced users only)
// needs to grow into full fledged event handling (sometimes)

public:
void dependent(event* e); // to define dependent events / handlers
void update(); // to activate dependent events/handlers

void timestamp(long t) { timestamp_ = t; }
long timestamp() { return timestamp_; }

protected:
event* next;
void insert(event*);
int contains(event*);
int secondary;
long timestamp_;
};

#endif
