'\"
'\" Copyright (c) 1994, 1995 Hakan Soderstrom and Tom Poindexter
'\" 
'\" Permission to use, copy, modify, distribute, and sell this software
'\" and its documentation for any purpose is hereby granted without fee,
'\" provided that the above copyright notice and this permission notice
'\" appear in all copies of the software and related documentation.
'\" 
'\" THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,
'\" EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY
'\" WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
'\" 
'\" IN NO EVENT SHALL HAKAN SODERSTROM OR SODERSTROM PROGRAMVARUVERKSTAD
'\" AB BE LIABLE FOR ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL
'\" DAMAGES OF ANY KIND, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS
'\" OF USE, DATA OR PROFITS, WHETHER OR NOT ADVISED OF THE POSSIBILITY
'\" OF DAMAGE, AND ON ANY THEORY OF LIABILITY, ARISING OUT OF OR IN
'\" CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
'\" 
'\" $Id: msqltcl.n,v 1.0 1995/01/05 11:13:05 hs Rel $
'\"
.TH "Msqltcl" TCL "" "Tcl"
.ad b
.SH NAME
Msqltcl - mSQL (Mini SQL) server access commands for Tcl
.SH "INTRODUCTION"
.P
Msqltcl is a collection of Tcl commands and a Tcl global array that
provide access to one or more mSQL database servers.
.P
Msqltcl does not attempt to mirror all of the mSQL API.
Rather, the idea is to provide a Tcl extension with facilities similar
to what can be expected from the more ``famous brands'' (Sybase and
Oracle in particular).
The main reason for this is that mSQL itself is designed to be mostly
downward compatible with the big SQL database vendors.
It is useful if a Tcl-based application can be easily moved between DBMSs.
For the same kind of compatibility the term \fIcolumn\fR is used in
msqltcl where the mSQL documentation uses \fIfield\fR.
.P
mSQL (Mini SQL) is a lightweight database engine developed by David J.
Hughes, Bond University, Australia.
At this writing the mSQL archive is located at Bond.edu.au in
/pub/Minerva/msql.
There is an mSQL mailing list; join it by sending a message to
\fImsql-list-request@Bond.edu.au\fR.
Please use these sources for information regarding mSQL itself.
The remainder of this man page is limited to msqltcl.
.sp
.SH "MSQLTCL COMMANDS"
.TP
.B msqlconnect \fI?hostname?\fR
.br
Connect to an mSQL server.
If \fIhostname\fR is specified, then an attempt will be made to connect
to a server located on this host.
\fIHostname\fR may be the name or the IP address of the desired host.
If \fIhostname\fR is omitted the connection is attempted on the local host.
.sp
A handle is returned which should be used in all other msqltcl
commands using this connection.
Multiple connections to the same or different servers are allowed, up
to a maximum of 15 total connections.
(This limit is a compilation constant.
However, an mSQL server will not accept more than 20 simultaneous
connections.)
msqlconnect raises a Tcl error if the connection fails.
.sp
.TP
.B msqluse \fIhandle dbname\fR
.br
Associate a connected handle with a particular database.
If successful the handle is said to be \fIin use\fR.
\fIHandle\fR must be a valid handle previously obtained from msqlconnect.
.sp
Msqluse raises a Tcl error if the handle is not connected or
if the database name specified could not be used.
.sp
.TP
.B msqlsel \fIhandle sel-query\fR
.br
Send \fIsel-query\fR, an mSQL SELECT statement, to the server.
The \fIhandle\fR must be in use (through msqlconnect and msqluse).
Any rows returned as the result of the query can be obtained by
the \fImsqlnext\fR and/or the \fImsqlmap\fR commands.
The resulting rows are called the \fIpending result\fR.
.sp
Msqlsel implicitly cancels any previous result still pending for the
handle.
.sp
If \fIsel-query\fR is a valid mSQL statement, but not a SELECT
statement, the statement will take effect although a Tcl error is
also generated.
Use the msqlexec command for non-SELECT statements.
.sp
.TP
.B msqlexec \fIhandle sql-statement\fR
.br
Send \fIsql-statement\fR, an mSQL non-SELECT statement, to the server.
The \fIhandle\fR must be in use (through msqlconnect and msqluse).
.sp
Msqlexec implicitly cancels any previous result pending for the handle.
.sp
If \fIsql-statement\fR is a valid mSQL SELECT statement, the statement
is executed, but the result is discarded.
No Tcl error is generated.
This amounts to a (potentially costly) no-op.
Use the msqlsel command for SELECT statements.
.sp
.TP
.B msqlnext \fIhandle\fR
.br
Return the next row of the pending result (from a previous msqlsel command).
The row is returned as a Tcl list.
Each list element contains the value of one column.
The order is determined by the SELECT statement.
A null column is converted to an empty string.
If there are no more rows the command returns an empty list.
.sp
Msqlnext raises a Tcl error if there is no pending result for \fIhandle\fR.
.sp
.TP
.B msqlmap \fIhandle binding-list script\fR
.br
Iterate a script over the rows of the pending result.
Msqlmap may consume all rows or only some of the rows of the pending
result.
Any remaining rows may be obtained by further msqlnext or msqlmap
commands.
.sp
\fIHandle\fR must be a handle with a pending result from a previous
msqlsel command.
\fIBinding-list\fR must be a list of one or more variable names.
\fIScript\fR must be a Tcl script.
It may be empty, but usually it contains one or more commands.
.sp
Msqlmap processes one row at a time from the pending result.
For each row the column values are bound to the variables in the
binding list, then the script is executed.
Binding is strictly positional.
The first variable in the binding list is bound to the first column of
the row, and so on.
The variables are created in the current context (if they do not
already exist).
A variable name beginning with a hyphen is not bound; it serves as a
placeholder in the binding list.
If there are more columns than variables the extra columns are
ignored.
.sp
The msqlmap command is similar to an ordinary \fBforeach\fR.
A \fBforeach\fR iterates over the elements of a list, msqlmap
iterates over the rows of a pending result.
In both cases iteration is affected by \fBbreak\fR and \fBcontinue\fR
Tcl commands.
The binding list variables retain their last values after the command
has completed.
.sp
An simple example follows.
Assume $db is a handle in use.\fB
.sp
	msqlsel $db {select lname, fname, area, phone from friends
.br
		order by lname, fname}
.br
	msqlmap $db {ln fn - phone} {
.br
		if {$phone == {}} continue
.br
		puts [format "%16s %-8s %s" $ln $fn $phone]
.br
	}\fR
.br
.sp
The msqlsel command gets and sorts all rows from table \fIfriends\fR.
The msqlmap command is used to format and print the result in a way
suitable for a phone list.
For demonstration purposes one of the columns (area) is not used.
The script begins by skipping over rows which have no phone number.
The second command in the script formats and prints values from the row.
.sp
Msqlmap raises a Tcl error if there is no pending result for
\fIhandle\fR, or if \fIbinding-list\fR contains more variables than
there are columns in the pending result.
.sp
.TP 
.B msqlcol \fIhandle table-name option\fR
.TP
.B msqlcol \fIhandle table-name option-list\fR
.TP
.B msqlcol \fIhandle table-name option ?option ...?\fR
.br
Return information about the columns of a table.
\fIHandle\fR must be in use.
\fITable-name\fR must be the name of a table; it may be a table name
or \fB-current\fR if there is a pending result.
One or more options control what information to return.
Each option must be one of the following keywords.
.RS
.TP
.B name
.br
Return the name of a column.
.TP
.B type
.br
Return the type of a column; one of the strings \fBint\fR, \fBreal\fR,
\fBchar\fR.
.TP
.B length
.br
Return the length of a column in bytes.
.TP
.B table
.br
Return the name of the table in which this column occurs.
.TP
.B non_null
.br
Return the string ``1'' if the column is non-null; otherwise ``0''.
.TP
.B prim_key
.br
Return the string ``1'' if the column is part of the primary key;
otherwise ``0''.
.RE
.sp
The three forms of this command generate their result in a
particular way.
.IP [1]
If a single option is present the result is a simple list of
values; one for each column.
.IP [2]
If the options are given in the form of an option list the
result is a list of lists.
Each sublist corresponds to a column and contains the information
specified by the options.
.IP [3]
If several options are given, but not in a list, the result is also
a list of lists.
In this case each sublist corresponds to an option and contains one
value for each column.
.sp
The following is a sample interactive session containing all forms of
the msqlcol command and their results.
The last command uses the \fB-current\fR option.
It could alternatively specify the table name explicitly.\fB
.sp
	% msqlcol $db friends name
.br
	fname lname area phone
.br
	% msqlcol $db friends {name type length}
.br
	{fname char 12} {lname char 20} {area char 5} {phone char 12}
.br
	% msqlsel $db {select * from friends}
.br
	% msqlcol $db -current name type length
.br
	{fname lname area phone} {char char char char} {12 20 5 12}\fR
.sp
.TP 
.B msqlinfo \fIhandle option\fR
.br
Return various database information depending on the \fIoption\fR.
The option must be one of the following keywords.
.RS
.TP
.B databases
.br
Return a list of all database names known to the server.
The handle must be connected.
.TP
.B dbname
.br
Return the name of the database with which the handle is associated.
The handle must be in use.
.TP
.B dbname?
.br
Return the name of the database with which the handle is associated;
an empty string if the handle is connected, but not in use.
.TP
.B host
.br
Return the name of the host to which the handle is connected.
(The handle must be connected.)
.TP
.B host?
.br
Return the name of the host to which the handle is connected; an empty
string if the handle is not connected.
.TP
.B tables
.br
Return a list of all table names in the database with which the handle
is associated.
The handle must be in use.
.RE
.TP 
.B msqlresult \fIhandle option\fR
.br
Return information about the pending result.
Note that a result is pending until cancelled by an msqlexec command,
even if no rows remain to be read.
\fIOption\fR must be one of the following keywords.
.RS
.TP
.B cols
.br
Return the number of columns in the pending result.
There must be a pending result.
.TP
.B cols?
.br
Return the number of columns in the pending result; an empty string if
no result is pending.
.TP
.B rows
.br
Return the number of remaining rows in the pending result.
There must be a pending result.
.TP
.B rows?
.br
Return the number of remaining rows in the pending result; an empty
string if no result is pending.
.RE
.TP 
.B msqlstate \fI?-numeric? handle\fR
.br
Return the state of a handle as a string or in numeric form.
There is no requirement on \fIhandle\fR; it may be any string.
The return value is one of the following strings, or the corresponding
numeric value if \fB-numeric\fR is specified.
The states form a progression where each state builds on the previous.
.RS
.TP
.B NOT_A_HANDLE (0)
.br
The string supplied for \fIhandle\fR is not an msqltcl handle at all.
.TP
.B UNCONNECTED (1)
.br
The string supplied for \fIhandle\fR is one of the possible msqltcl
handles, but it is not connected to any server.
.TP
.B CONNECTED (2)
.br
The handle is connected to a server, but not associated with a database.
.TP
.B IN_USE (3)
.br
The handle is connected and associated with a database, but there is
no pending result.
.TP
.B RESULT_PENDING (4)
.br
The handle is connected, associated with a database, and there is a
pending result.
.RE
.sp
.TP 
.B msqlclose \fI?handle?\fR
.br
Closes the server connection associated with \fIhandle\fR, causing it
to go back to the unconnected state.
Closes all connections if \fIhandle\fR is omitted.
Returns an empty string.
Msqlclose raises a Tcl error if the handle specified is not connected.
.sp
.SH "SERVER MESSAGE AND ERROR INFORMATION"
.P
Msqltcl creates and maintains a Tcl global array to provide feedback of
mSQL server messages.
Its name is \fBmsqlstatus\fR.
Its elements are set after each msqltcl command.
.P
Msqlstatus elements:
.sp
.TP
.B code
.br
A numeric conflict code.
Zero means no conflict; non-zero means some kind of conflict.
All conflicts also generate a Tcl error.
.sp
Almost all conflicts set msqlstatus(code) to -1.
The only exception is when a Unix system call in msqltcl fails.
Then the Unix \fIerrno\fR (a positive integer) is assigned to
msqlstatus(code).
.sp
.TP
.B message
.br
Conflict message string.
Empty if there is no conflict.
In many cases this message contains more precise information than the
result string returned by the failing command.
.sp
.SH ENVIRONMENT VARIABLES
.P
None.
.sp
.SH BUGS & POSSIBLE MISFEATURES
.P
Sure.
.P
Some of the options of the information commands (msqlinfo, msqlresult,
msqlcol, msqlstate) keep returning results even if the mSQL server has
ceased to exist.
.P
Deleting any of the msqltcl commands closes all connections.
.P
In mSQL a NULL value cannot be distinguished from an empty string in a
char column.
An mSQL server seems to hang if more than 20 simultaneous connections
are attempted.
.sp
.SH AUTHOR
Hakan Soderstrom (hs@soderstrom.se), Soderstrom Programvaruverkstad,
S-12242 Enskede, Sweden.
Msqltcl is derived from Sybtcl by Tom Poindexter (tpoindex@nyx.cs.du.edu).
.sp
$Revision: 1.0 $
