/*
 * delete.c 
 *
 * Copyright (c) 1994
 *
 * M. Kernchen
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#include "cmip.h"

int
cmip_delete(clientData, interp, argc, argv)
    ClientData	  clientData;	/* (char *) to the cmip handle */
    Tcl_Interp  *interp;
    int          argc;
    char       **argv;
{
    char	 *cmipHdl = (char *) clientData;

    char	 *strObjClass = NULLCP;
    char	 *strObjInst  = NULLCP;
    char	 *strScope    = NULLCP;
    char	 *strSync     = NULLCP;
    char	 *strFilter   = NULLCP;

    char	 *callback    = NULLCP;
    char	 *errorback   = NULLCP;

    int		  listArgc;
    char	**listArgv;
    int		  strFilterLength;

    int		  i, j, status;
 
    MIDentifier	  obj_class;
    MName	  obj_inst;
    CMISScope	 *scope    = NULLMSCOPE;   /* default: no scoping */
    CMISSync	  sync     = s_bestEffort; /* default: best effort synchron. */
    CMISFilter	 *filter   = NULLMFILTER;  /* default: no filtering */

    MSAPIndication	mi;

    cmipHandle    *cmiph;
    requestHandle *rh;

    Tcl_HashEntry *ht_entry;
    int		   flag = 0;

    char	buf[256];

    /* parse command line arguments */

    if (argc < 4)
	goto usage;

    if (argv[2][0] != '\0') strObjClass = argv[2];
    if (argv[3][0] != '\0') strObjInst  = argv[3];

    if (!strObjClass ||
	(!strObjInst && strcmp(strObjClass, "system") != 0)) {
	goto usage;
    }

    /* the optional parameter */
    i = 4;
    while (i < argc) {
	if (i == argc-1) {
	    goto usage;
	}
        if ((argv[i][0] == 's') && (strcmp(argv[i], "scope") == 0)) {
	    if (strScope) {
		Tcl_AppendResult (interp, "duplicate keyword \"", argv[i],
				  "\"", (char *) NULL);
		return TCL_ERROR;
	    }
            strScope = argv[++i];
	    /* synchronisation only makes sense, if there is a scope */
	    if ((i < argc-1) &&
		(argv[i+1][0] == 'a') && (strcmp(argv[i+1], "atomic") == 0)) {
		    strSync = argv[++i];
	    }
        } else if ((argv[i][0] == 'f') && (strcmp(argv[i], "filter") == 0)) {
	    if (strFilter) {
		Tcl_AppendResult (interp, "duplicate keyword \"", argv[i],
				  "\"", (char *) NULL);
		return TCL_ERROR;
	    }
            if (Tcl_SplitList(interp, argv[++i], &listArgc,
                              &listArgv) != TCL_OK) {
                return TCL_ERROR;
            }
	    if (listArgc <= 0) goto usage;
            for (j=0, strFilterLength=0; j < listArgc; j++)
                strFilterLength += strlen(listArgv[j])+1; /* +1 for ' ' */
            strFilter = xmalloc(strFilterLength);
            *strFilter= '\0';
            for (j=0; j < listArgc; j++) {
                strcat(strFilter, listArgv[j]);
                strcat(strFilter, " ");
            }
            free((char *)listArgv);
        } else if ((argv[i][0] == 'c') &&
		   (strcmp(argv[i], "callback") == 0)) {
	    if (callback) {
		Tcl_AppendResult (interp, "duplicate keyword \"", argv[i],
				  "\"", (char *) NULL);
		return TCL_ERROR;
	    }
            callback = argv[++i];
	    if (i < argc-2 && argv[i+1][0] == 'e' &&
		strcmp(argv[i+1], "errorback") == 0) {
		if (errorback) {
		    Tcl_AppendResult (interp, "duplicate keyword \"",
				      argv[i+1], "\"", (char *) NULL);
		    return TCL_ERROR;
		}
		i += 2;
		errorback = argv[i];
	    }
        } else {
	    Tcl_AppendResult (interp, "no such keyword: \"", argv[i], "\"",
			      (char *)NULL);
	    return TCL_ERROR;
	}
        i++;
    }
#ifdef DEBUG_CMIP
    fprintf(stderr, "Aufruf: \"%s %s", argv[0], argv[1]);
    if (strObjClass)
      fprintf(stderr, " %s", strObjClass);
    if (strObjInst)
      fprintf(stderr, " %s", strObjInst);
    if (strScope)
      fprintf(stderr, " scope %s", strScope);
    if (strSync)
      fprintf(stderr, " sync %s", strSync);
    if (strFilter)
      fprintf(stderr, " filter {%s}", strFilter);
    fprintf(stderr, "\"\n");
#endif

    ht_entry = Tcl_FindHashEntry(&cmip_table, cmipHdl);
    if (ht_entry == NULL) {
        Tcl_AppendResult (interp, "no such cmip handle \"", cmipHdl, "\"",
                          (char *) NULL);
        return TCL_ERROR;
    }
    cmiph = (cmipHandle *) Tcl_GetHashValue (ht_entry);

    /* convert the string arguments to CMIS parameters */

    if ((obj_class.mid_global = name2oid(strObjClass)) == NULLOID) {
        Tcl_AppendResult (interp, "no such object class \"", strObjClass, "\"",
                          (char *)NULL);
        return TCL_ERROR;
    }
    obj_class.mid_type   = MID_GLOBAL;

/*
    if (strObjInst && strncasecmp(strObjInst, "systemId=", 9) == 0) {
*
    if (strObjInst && strncasecmp(strObjInst, "sysName=", 8) == 0) {
        strObjInst = strchr(strObjInst, '@');
        if (strObjInst) ++strObjInst;
    }
*/
    if (strObjInst) {
	if ((obj_inst.mn_dn = str2dn(strObjInst)) == NULLDN) {
	    Tcl_AppendResult (interp, "no such object instance \"", strObjInst,
			      "\"", (char *)NULL);
	    return TCL_ERROR;
	}
    } else {
	obj_inst.mn_dn = dn_comp_new(NULLRDN);
    }
    obj_inst.mn_type = MN_DN;

    if (strScope && (scope = str2scope(strScope)) == NULLMSCOPE) {
        Tcl_AppendResult (interp, "no such scope \"", strScope, "\"",
                          (char *)NULL);
        return TCL_ERROR;
    }

    if (strSync && (sync = str2sync(strSync)) == s_invalid) {
        Tcl_AppendResult (interp, "no such synchronisation \"", strSync, "\"",
                          (char *)NULL);
        return TCL_ERROR;
    }

    if (strFilter && strFilter[0] != '\0'  &&
                (filter = str2mfilter(strFilter)) == NULLMFILTER) {
        Tcl_AppendResult (interp, "no such filter \"", strFilter, "\"",
                          (char *)NULL);
        return TCL_ERROR;
    }

    /* perform the M-DELETE request */
    status = M_Delete(cmiph->msd, cmiph->req_nr, &obj_class, &obj_inst, scope,
				filter, NULLMACCESS, sync, &mi);

    if (status == NOTOK) {
        Tcl_AppendResult (interp, argv[0], " ", argv[1], ": ",
			  mi.mi_preject.mpr_data,
                          (char *)NULL);
        return TCL_ERROR;
    }

    sprintf(buf, "delete%d", cmiph->req_nr); /* compose the request handle */
    rh = (requestHandle *) xmalloc(sizeof(requestHandle));
    rh->reqHdl	     = xstrdup(buf);
    rh->request_id   = cmiph->req_nr;
    rh->reqId	     = xstrdup("DELETE");
    rh->reqcallback  = callback ? xstrdup(callback) : NULLCP;
    rh->reqerrorback = errorback ? xstrdup(errorback) : NULLCP;
    Tcl_DStringInit (&rh->dStrResult);

    (cmiph->req_nr)++;

    ht_entry = Tcl_CreateHashEntry (cmiph->req_table, rh->reqHdl, &flag);
    if (flag != 1) {
        /* shouldn't really happen */
	Tcl_AppendResult (interp, "*** request handle already exist!? ***",
			  (char *)NULL);
        return TCL_ERROR;
    }
    Tcl_SetHashValue (ht_entry, (ClientData) rh);

    /* release memory of arguments (for the sake of it...) */
    mid_free(&obj_class);
    mn_free(&obj_inst);
    if (scope)
	free((char*) scope);
    if (filter)
	mfilter_free(filter);
    free((char*) strFilter);

    if (callback) { /* asynchron */
	status = TCL_OK;
    } else {
	/* synchron: do while there are outstanding responses */
	do {
	    status = wait(cmipHdl, interp, rh);
	    switch (status) {
	    case TCL_OK:
		Tcl_DStringResult(interp, &rh->dStrResult);
	    case TCL_ERROR:
	    case TCL_CONTINUE:
		break;
	    default:
		sprintf(buf, "\"$d\"", status);
		Tcl_AppendResult(interp, "cmip_delete():", 
				 " unexpected returnvalue from wait() ",
				 buf, (char*)NULL);
		return TCL_ERROR;
	    }
	} while (status == TCL_CONTINUE);

	Tcl_DeleteHashEntry(ht_entry);
	rh_free(rh);
    }
    return status;

 usage:
    Tcl_AppendResult(interp, "wrong # args: should be \"",
		     argv[0], " ", argv[1],
		     " <class> <instance>",
		     " [scope <scope> [atomic]]",
		     " [filter <filterList>]",
		     " [callback <callback> [errorback <errorback>]]\"",
		     (char *)NULL);
    return TCL_ERROR;
} /* cmip_delete() */
