/*
 * event.h
 *
 * Copyright (c) 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/*
 * These three functions are installed in the event handler and
 * called to process timeout, response and trap events.
 */

void
SNMP_TimeoutEvent	_ANSI_ARGS_((ClientData clientData));

void
SNMP_ResponseEvent	_ANSI_ARGS_((ClientData clientData, int mask));

void
SNMP_TrapEvent		_ANSI_ARGS_((ClientData clientData, int mask));

void
SNMP_AgentEvent		_ANSI_ARGS_((ClientData clientData, int mask));

/*
 * These are the definitions found in the TK library and reprogrammed
 * in scotty's event.c. They will be replaced by the TK versions once 
 * TK 4.0 comes out. John Ousterhout announced that the event loop of 
 * TK will be usable without any further access to the X11 server.
 */

#define TK_READABLE	1    /* Corresponding to the tk definition */
#define TK_WRITABLE	2    /* Corresponding to the tk definition */
#define TK_EXCEPTION	4    /* Corresponding to the tk definition */

typedef void (Tk_FileProc)  _ANSI_ARGS_((ClientData clientData, int mask));
typedef void (Tk_TimerProc) _ANSI_ARGS_((ClientData clientData));

typedef struct Tk_TimerToken_ *Tk_TimerToken;

extern Tk_TimerToken	Tk_CreateTimerHandler _ANSI_ARGS_((int milliseconds,
			    Tk_TimerProc *proc, ClientData clientData));
extern void             Tk_DeleteTimerHandler _ANSI_ARGS_((
                            Tk_TimerToken token));
extern void             Tk_CreateFileHandler _ANSI_ARGS_((int fd, int mask,
			    Tk_FileProc *proc, ClientData clientData));
extern void		Tk_DeleteFileHandler _ANSI_ARGS_((int fd));

