/*
 * mib_query.h
 *
 * Copyright (c) 1994
 *
 * Sven Schmidt, J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#define SYMBOL_MAXLEN 64	/* maximum characters in a symbol */

#define STATIC_BUFFER_SIZE 256	/* shouldn't use this ... */

struct idesc {
    char *desc;
    char *val;
    struct idesc *next;
};

/*
 * storage to save the textual-convetion types found:
 * if textconv is set, this is a printf format,
 * if desc is set, these are pairs of name/value.
 */
struct textual_type {
    char *name;			/* name, eg: DnsClass */
    short syntax;		/* eg. INTEGER */
    char *textconv;		/* eg. 2d */
    struct idesc *desc;		/* the int_desc as list */
    struct textual_type *next;	/* next in the chain */
};


/*
 * The following structure is used to hold the MIB tree in memory.
 * Every node is linked with its parent, a list of child nodes and
 * the next node on the current MIB level.
 */

struct tree {
    char 	*label;		/* This node's (unique) textual name        */
    char *parent_name;		/* Name of parent node during parse         */
    u_int	subid;		/* This node's integer subidentifier        */
    char        *filename;      /* The file with the Textual Description    */
    int		description;	/* Index value for node Textual Description */
    short	syntax;		/* This node's object type syntax           */
    u_char	access;		/* The access mode of the object	    */
    struct textual_type *tt;	/* Format hint				    */
    struct tree	*parent;	/* Parent of this node		            */
    struct tree	*child;		/* Child of this node		            */
    struct tree	*next;		/* Next node in list of peers               */
};

#define M_NOACCESS	0
#define M_READONLY      1
#define M_READCREATE	2
#define M_READWRITE 	3
#define M_WRITEONLY	4

/*
 * Function to access the information stored in the MIB tree.
 */

int
MIB_Load	_ANSI_ARGS_((Tcl_Interp *interp, char *file));

char*		
MIB_Oid		_ANSI_ARGS_((char *name, int exact));

char*		
MIB_Name	_ANSI_ARGS_((char *oid,  int exact));

char*		
MIB_Syntax	_ANSI_ARGS_((char *name, int exact));

char*		
MIB_Description	_ANSI_ARGS_((char *name, int exact));

char*
MIB_Access	_ANSI_ARGS_((char *name, int exact));

char*
MIB_Succ	_ANSI_ARGS_((char *name));

char*
MIB_Format	_ANSI_ARGS_((char *name, int exact, char *arg));

char*
MIB_Scan	_ANSI_ARGS_((char *name, int exact, char *arg));

int		
MIB_ASN1	_ANSI_ARGS_((char *name, int exact));

struct tree*
MIB_FindNode	_ANSI_ARGS_((char *name, char *soid, int exact));


/*
 * Functions to read a file containing mib definitions.
 */

struct tree*	
MIB_Parse	_ANSI_ARGS_((char *file, struct tree *root));

