/*
 * udp.h
 *
 * Copyright (c) 1994
 *
 * Sven Schmidt, J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

/*
 * The size of the internal buffer used to decode or assemble
 * SNMP packets.
 */

#define BUFSIZE	4096

/*
 * The following function is used to create a socket used for
 * all manager initiated communication. The Close function
 * is used to close this socket if all SNMP sessions have been
 * destroyed.
 */

int
SNMP_ManagerSocket	_ANSI_ARGS_((Tcl_Interp	*interp));

void
SNMP_ManagerClose	_ANSI_ARGS_((void));

/*
 * Management communication initiated by an agent is normally
 * done using traps. Because traps are sent to port 162 (which
 * requires special privileges, we read the from the straps
 * process via a unix domain socket.
 */

int
SNMP_TrapSocket		_ANSI_ARGS_((Tcl_Interp *interp));

void
SNMP_TrapClose		_ANSI_ARGS_((void));

/*
 * Create and close a socket used for the agent part. This socket
 * used to process messages received from other agents.
 */

int
SNMP_AgentSocket	_ANSI_ARGS_((Tcl_Interp *interp, 
				     struct session *session));

void
SNMP_AgentClose		_ANSI_ARGS_((struct session *session));

/*
 * Functions used to send and receive SNMP messages. The SNMP_Wait
 * function is used to wait for an answer.
 */

int
SNMP_Send		_ANSI_ARGS_((Tcl_Interp *interp,
				     struct session *sess,
				     u_char *packet,
				     int packetlen));
int
SNMP_Recv		_ANSI_ARGS_((Tcl_Interp *interp,
				     u_char *packet,
				     int *packetlen));

int 
SNMP_Wait		_ANSI_ARGS_((int ms));

int
SNMP_TrapRecv		_ANSI_ARGS_((Tcl_Interp *interp,
				     u_char *packet,
				     int *packetlen));

int
SNMP_AgentRecv		_ANSI_ARGS_((Tcl_Interp *interp,
				     struct session *session,
				     u_char *packet,
				     int *packetlen));

/*
 * A utility function to convert host names to IP addresses.
 */

int
SNMP_Host2Addr		_ANSI_ARGS_((Tcl_Interp *interp, char *host,
				     unsigned short port, 
				     struct sockaddr_in *addr));
