/*
 * xread.c
 *
 * A fail-save read and write (for all those broken SYSV 
 * machines out there).
 *
 * Copyright (c) 1994
 *
 * J. Schoenwaelder
 * TU Braunschweig, Germany
 * Institute for Operating Systems and Computer Networks
 *
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that this copyright
 * notice appears in all copies.  The University of Braunschweig
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#include <errno.h>

#include <tcl.h>

#include "xread.h"

/*
 * Write a buffer to a file descriptor. This wrapper is needed on
 * broken SYS V machines.
 */

int
xwrite (fd, buf, len)
    int fd;
    char *buf;
    int len;
{
    int rc;

    do {
	while ((rc = write (fd, buf, len)) < 0
	       && (errno == EINTR || errno == EAGAIN))
		continue;
	len -= rc;
	buf += rc;
    } while ((len > 0) && (rc > 0));

    return rc;
}

/*
 * Read a buffer from a file descriptor. This wrapper is needed on
 * broken SYS V machines.
 */

int 
xread (fd, buf, len)
    int fd;
    char *buf;
    int len;
{
    int rc;

    while ((rc = read (fd, buf, len)) < 0
	   && (errno == EINTR || errno == EAGAIN))
	    continue;

    return rc;
}
