.TH TmList 3 "24 July 1993"
.SH NAME
.B TmList
- the List widget class
.SH SYNOPSIS
.B xmList
\ pathName [options]
.br
.SH DESCRIPTION
This is the
.I tcl
binding to the Motif List widget.
.SH CLASSES
The class name for resource files is
.B XmList.
Resources are inherited from
.B TmPrimitive, TmCore.
Methods are inherited from
.B TmCore.
.SH RESOURCES
The new resources are
.IP
automaticSelection
.br
doubleClickInterval
.br
itemCount
.br
items
.br
listMarginHeight
.br
listMarginWidth
.br
listSizePolicy
.br
listSpacing
.br
scrollBarDisplayPolicy
.br
selectedItemCount
.br
selectedItems
.br
stringDirection
.br
topItemPosition
.br
visibleItemCount

.LP
.TP 5 5
.B itemCount
The value for this resource is the number of
.B items.
If this number is different from the actual number of items in the list,
Motif will probably core dump.
.TP 5 5
.B items
The value for this resource is a
string consisting of words separated by commas.
An item may contain a comma if it is prefixed by the escape
character as in `\\,'.

.TP 5 5 
.B selectionPolicy
The values for this resource are
.RS 10
single_select
.br
multiple_select
.br
extended_select
.br
browse_select
.br
extendedSelectionCallback
.br
multipleSelectionCallback
.br
singleSelectionCallback

.RE 10
.SH METHODS
The extra methods supported for this class are
.IP
addItem
.br
addItemUnselected
.br
deleteItem
.br
deleteAllItems
.br
deletePosition
.br
deselectAllItems
.br
deselectItem
.br
deselectPosition
.br
itemExists
.br
positionSelected
.br
selectItem
.br
selectPosition
.br
setBottomItem
.br
setBottomPosition
.br
setItem
.br
setPosition
.br
browseSelectionCallback
.br
defaultActionCallback
.br
.LP
.TP 5 5
\fB addItem\fR item position
Add an item to the list at a particular position.
A position of 1 makes it the first, 2 makes it second, etc.
A position of 0 makes it the last item.

.TP 5 5
\fB addItemUnselected\fR item position
Add an item to the list at a particular position.
Do not select the item even if it is in the selected set.

.TP 5 5 
\fB deleteItem\fR item
Delete the first matching item from the list.

.TP 5 5
\fB deletePosition\fR position
Delete the item at the position in the list.

.TP 5 5
.B deselectAllItems
remove all items from the selected set.

.TP 5 5
\fB deselectItem \fR item
Deselect the first item in the selected set that matches the item.

.TP 5 5
\fB deselectPosition\fP position
Deselect the item at the specified position.

.TP 5 5
\fB itemExists \fP item
returns "true" if the item is in the list, otherwise "false"

.TP 5 5
\fB itemPosition \fP item
returns the position of the item in the list.

.TP 5 5
\fB selectItem \fP item notify
Selects the item, and if notify is true calls the selection callback

.TP 5 5
\fB selectPosition\fP position notify
Selects the item at the position, and if notify is true calls the
selection callback.

.TP 5 5
\fB setBottomItem\fP item
make the specified item the last visible item in the list

.TP 5 5
\fB setBottomPosition \fP position
make the item at the position the last visible item in the list.

.TP 5 5
\fB setItem \fP item
make the item the first visible item in the lis

.TP 5 5
\fB setItem \fP item
make the item the first visible item in the list

.SH "CALLBACK SUBSTITUTIONS
The following substitutions are supported:
.RS 5
.B %reason
- the additional values are
.RS 5
browse_select 
.br
default_action 
.br
extended_select
.br
multiple_select 
.br
single_select
.RE
.B %item 
- the selected item.
.br
.B %item_position 
- the position of the selected item.
.br
.B %selected_items 
- the list of selected items.
.br
.B %selected_item_count 
- the number of selected items.
.br
.B %selection_type
- one of 
.B initial modification addition
.RE 5
.SH BUGS
If the number of items is different from the number set in itemCount,
Motif will probably core dump.

The list of items is a tcl list.
This is different to the comma-separated list usually used
by Motif.
Sorry about the inconsistency.

.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
