.TH TmUIL 3 "24 July 1993"
.SH NAME
.B TmUIL
- the interface to the UIL system
.SH DESCRIPTION
This is the interface to handling UIL files in tclMotif.
.SH METHODS
The extra methods supported for handling UIL files are
.IP
mrmOpenHierarchy
.br
mrmCloseHierarchy
.br
mrmFetchWidget
.br
mrmFetchWidgetOverride
.LP
.TP 5 5
\fB mrmOpenHierarchy\fR file_list
This takes a list of files that are compiled UIL files (UID files)
and opens the widget hierarchy. At most one widget hierarchy can 
be opened.
This method is only available to the toplevel widget ``.''

.TP 5 5
\fB mrmCloseHierarchy\fR
This closes the widget hierarchy opened by mrmOpenHierarchy.
This method is only available to the toplevel widget ``.''

.TP 5 5 
\fB mrmFetchWidget\fR name
This method can be applied to any widget.
It searches the opened hierarchy for the widget given by ``name''
and attaches it to the widget of the call.

.TP 5 5 
\fB mrmFetchWidgetOverride\fR name [override-name] args...
This method can be applied to any widget.
It searches the opened hierarchy for the widget given by ``name''
and attaches it to the widget of the call.
The override-name can be used to specify a new widget name for the top
widget, and the args list can be used to override resource values
for the top widget.

.SH Callbacks
Callbacks can be defined for widgets within UIL files. These should all
call to the function ``tcl'' which takes a string argument.
The string is the tcl command that will be executed when the callback
is invoked.

.SH "Widget commands
When a widget tree is linked into the tclMotif tree by mrmFetchWidget,
a traversal is made of this subtree, adding information to turn each
of the UIL widgets into a tclMotif widget. This means that the UIL
widgets can then be treated as tclMotif Core widgets, and use the
Core methods such as manageChild, getValues, setValues, etc.

.SH "Testing UIL capability
Support for UIL is determined by a compile-time option in the tclMotif
library. Early versions of tclMotif have no support. You can test for
UIL support by examining the variable Tm_UIL. If this variable is not
defined, then there is no support for UIL. If it has the value false (0)
then the library has been compiled without support, and if it has the
value true (1), it supports the Mrm functions.

.SH BUGS
When the UIL tree is added, all the widgets in this are made into Core
widgets rather than using their widget type to set appropriate methods.
Complain if this is important to you.

.SH AUTHOR
.LP
Jan Newmarch, University of Canberra
