/* 
 * tmExtern.c --
 *
 *      This file contains the definitions of any other widgets
 *	that are to be added to the standard Motif set
 *
 * Copyright 1993 Jan Newmarch, University of Canberra.
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for any purpose and without
 * fee is hereby granted, provided that the above copyright
 * notice appear in all copies.  The author
 * makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 */


#include "tmFuncs.h"
#include <Xm/Xm.h>


/*
 * include your own stuff here e.g.
 * #include <HTML.h>
 */

/* 
 * this array defines the extra widget commands that you want to add
 * to tclMotif. The elements of this structure are
 *	- the string that is the widget creation name 
 *	- the  C function that is used to actually create the widget
 *	- the C function that is used to process the commands issued
 *	  to the new widget
 *
 * If there is nothing special about creating this widget, make the
 * second element of this array Tm_AnyCmd.
 *
 * If the widget has no special methods of its own, make the third
 * element of this array Tm_AnyWidgetCmd.
 *
 */

Tm_Cmd Tm_ExternCommands[] = {

    /*
     * Example: the Mosaic HTML widget needs no special setup and has
     * no special methods of its own. So use this line:
    	{"htmlWidget",     Tm_AnyCmd,      Tm_AnyWidgetCmd},
     */

    /*
     * Example: you have a widget that say has children that also need
     * to be registered, and which has its own methods. For this use:
	{"myWidget",       MyCreateCmd,    MyWidgetCmd}
     */

    /*
     * array terminator - do not remove or place anything after this
     */
    {(char *) NULL,	(int (*)()) NULL, (Tm_WidgetCmdProc) NULL}
};

/*
 * this array defines the mapping from the widget creation string
 * to the widget's class. It is only used if the creation command
 * uses Tm_AnyCmd.
 *
 * The structure has two elements:
 *	- the first is the name of the command
 *	- the second is a pointer to the widget's class
 */
Tm_CommandToClassType Tm_ExternCommandToClass[] = {

    /*
     * Example: the Mosaic html widget:
	{"htmlWidget", &htmlWidgetClass},
     */

    /*
     * array terminatory - do not remove or place anything after this
     */
    {NULL, NULL}
};

/*
 * this array defines the additional reasons used in widget callbacks.
 * it defines the string that will be substituted for %reason
 *
 */
Tm_ReasonType Tm_ExternReasons[] = {
    /*
     * Regrettably, the html widget doesn't have any :-(
     * If it did, we might have stuff like
	{XmCR_ANCHOR,	"anchor"},
     */ 

    /*
     * array terminatory - do not remove or place anything after this
     */
    {-1, NULL}
};

/*
 * additional initialisation work for your widgets.
 */
void
Tm_ExternWidgetsInitialise(interp)
    Tcl_Interp *interp;
{
    /*
     * you could add in additional resource converters here
     * for the additional widgets if they need any
     * or do anything else, for that matter.
     */
    
    /* Place your own external widgets initialisation code here */
}

/*
 * Tm_ExternExpandPercent
 *	allows you to expand callback info for
 *	your widget using the % substitutions 
 *	e.g.
 *		%x %item
 *
 *	Return: the replacement string
 */
char *
Tm_ExternExpandPercent(pathName, w, event,
		call_data, value, length)
    char *pathName; 		/* the tclMotif name of the widget */
    Widget w;			/* the Xt widget */
    XEvent *event;		/* the event that triggered the callback */
    XtPointer call_data;	/* the call_data to the callback */
    char *value;		/* the string after the '%' symbol */
    int length;			/* the length of the token after the '%' */
{

    /* Place your own external widgets expand percents code here */

#if 0
    /* 
     * make a branch for each of the widgets that you have added
     * e.g. the html widget:
     */
    if (XtIsSubclass(w, htmlWidgetClass)) {
	/*
	 * now we can coerce the call_data into our widget type  -
	 * that is, if we can figure it out from the info above.
	 * e.g. assume that we have a WbAnchorCallbackData callback
	 */
	WbAnchorCallbackData *c_data = (WbAnchorCallbackData *) call_data;	

	/*
	 * examine each possible field of the callback struct in turn
	 */
	if (length == strlen("element_id") && 
		strncmp(value, "element_id", length) == 0) {

	    /*
	     * this is an int value in this field, so convert to string
	     */
	    static char buf[16];

	    sprintf(buf, "%d", c_data->element_id);
	    return buf;
	} else
	
	if (length == strlen("text") &&
		strncmp(value, "text", length) == 0) {

	    /*
	     * this is a string, so just return it
	     */
	    return c_data->text;
	} else

	if (length == strlen("href") &&
		strncmp(value, "href", length) == 0) {

	    return c_data->href;
	} else {
	    /*
	     * this occurs when the field asked for is not supported -
             * often caused by a typo in the user's program
	     */
	    return "ERROR in substitution";
	}
    }
#endif /* 0 */

    /*
     * it doesn't belong to the extended set of widgets
     */
    return "ERROR in substitution";
}

/*
 * MyCreateCmd
 *	Does whatever is needed to set up your widget.
 *	Just add to the code in here
 */

#if 0
int
MyCreateCmd(clientData, interp, argc, argv)
    ClientData clientData;	/* Main window associated with
				 * interpreter. */
    Tcl_Interp *interp;		/* Current interpreter. */
    int argc;			/* Number of arguments. */
    char **argv;		/* Argument strings. */
{

    register Tm_Widget *wPtr;
    Widget new, parent;
    char *command = argv[0];
    char *path = argv[1];
    Arg args[TM_MAXARGS];
    int num_args;
    WidgetClass class = NULL;
    Tm_WidgetCmdProc widgetCmdProc;
    Boolean managed = False;
    Tcl_CmdInfo parentInfo;

    /* SET YOUR VALUE FOR class IN HERE */
    class = ???;
 
    widgetCmdProc = (Tm_WidgetCmdProc) clientData;

    parent = Tm_ParentWidgetFromPath (interp, path);
    if (parent == NULL)
	return TCL_ERROR;

    if (argc >= 3 && strcmp(argv[2], "managed") == 0) {
	managed = True;
	argv++;
	argc--;
    }

    /* make sure class is initialized before using XtConvertAndStore */
    XtInitializeWidgetClass(class);

    if (Tm_SetValues(path, interp, parent, parent, class,
		argv + 2, argc - 2, args, &num_args) == TCL_ERROR)
	return TCL_ERROR;
    new = XtCreateWidget (Tm_NameFromPath(path), class, parent, args, num_args);

    if (managed) {
        XtManageChild (new);
    }

    Tcl_GetCommandInfo(interp, Tm_ParentPath(path), &parentInfo);
    Tm_CreateTmInfo(interp, new, path, Tm_ParentPath(path),
		((Tm_Widget *) parentInfo.clientData)->displayInfo);

    /* 
     * now all the stuff that tclMotif needed is done,
     * place whatever is unusual in your widget
     */

    return TCL_OK;
}
#endif /* 0 */

/*
 * MyWidgetCmd
 *	put the code in here to handle the methods
 *	specific to your widget
 */
#if 0
int
MyWidgetCmd (clientData, interp, argc, argv)
    ClientData clientData;
    Tcl_Interp *interp;
    int argc;
    char **argv;
{
    Tm_Widget *wPtr = (Tm_Widget *) clientData;
    Widget w = wPtr->widget;

    if (argc < 2) {
        sprintf(interp->result,
                "wrong # args: should be \"%.50s option [arg arg ...]\"",
                argv[0]);
        return TCL_ERROR;
    }

    /*
     * Put however many if...then...else branches you want.
     * terminate with a call to Tm_AnyWidgetCmd so that
     * it will pick up the standard methods
     */
    if (strcmp(argv[1], "...") == 0) {
	...
	return TCL_OK;
    } else
    if (strcmp(argv[1], "...") == 0) {
	...
	return TCL_OK;
    } else {
        return Tm_AnyWidgetCmd(clientData, interp, argc, argv);
    }
}
#endif /* 0 */
