#!/usr/local/bin/tclXess -f
#
# Xess Connection Library V2.1
# Copyright 1993, 1994 Applied Information Systems
# All rights reserved
#
# This example "fakes" the monitoring of real-time data (in this case,
# computer network performance data) with the XESS spreadsheet.
#
# This is a rough translation of example2.c


set doingit 0
set mon_row 0
set mon_col 0
set recalc_flag 0
set n 0
set loc "A1"

proc doit {} {
    global n mon_row mon_col recalc_flag doingit

    if {$doingit == 0} {
	# we were turned off
	return 0
    }

    # fake some data to monitor
    set net  [expr {floor(10000.0 * (sin(1.0 * $n) + 1.0))}]
    set disk [expr {floor(1000.0  * (sin(1.5 * $n) + 1.0))}]
    incr n
    # Store the three values.  encode_cell is used to
    # create a cell specification (like "A1") from the
    # numbers calculated.
    port store [xess encode_cell [expr $mon_row + 1] \
                                 [expr $mon_col + 1] 00] \
               "$n"
    port store [xess encode_cell [expr $mon_row + 2] \
                                 [expr $mon_col + 1] 00] \
               "$net"
    port store [xess encode_cell [expr $mon_row + 3] \
                                 [expr $mon_col + 1] 00] \
               "$disk"
    # force a recalculation if desired
    if {$recalc_flag != 0} {
	port recalc -force \
                    [xess encode_range  \
                          {[expr $mon_row + 1] \
                           [expr $mon_col + 1] 00} \
                          {[expr $mon_row + 3] \
                           [expr $mon_col + 1] 00}]
    }

    # syncronize with Xess
    port flush

    # schedule an update in 5 seconds
    after 5000 doit
}


proc b1_fn {} {	# start monitoring
    global doingit mon_row mon_col loc

    # current location of the cursor will be the base from which the
    # positions of the other cells are calculated
    set loc [port get_location]
    # transform the string returned from get_location into a list of
    # numbers that are easy to work with
    set dloc [xess decode_cell $loc]
    # now use lindex to dig the row and column numbers out
    set mon_row [lindex $dloc 0]
    set mon_col [lindex $dloc 1]

    # put a message on the Xess message line
    port message "Monitoring Enabled"
    # put strings in cells relative to the base we grabbed earlier
    port store $loc "System Stats"
    port store [xess encode_cell \
                     [expr $mon_row + 1 ] $mon_col 11 ] "Interval #"
    port store [xess encode_cell \
                     [expr $mon_row + 2 ] $mon_col 11 ] "Network I/O"
    port store [xess encode_cell \
                     [expr $mon_row + 2] [expr $mon_col +2] 11] "packets"
    port store [xess encode_cell \
                     [expr $mon_row + 3] $mon_col 11] "Disk I/O"
    port store [xess encode_cell \
                     [expr $mon_row + 3] [expr $mon_col +2] 11] "seeks"
    # set doingit to tell doit that it should run.
    set doingit 1
    # start putting up stats
    doit
}

proc b2_fn {} {	# stop monitoring
    global doingit

    # tell doit to quit running
    set doingit 0
    # tell the Xess user
    port message "Monitoring Disabled"
}

proc b3_fn {} {	# Toggle recalculation flag
    global recalc_flag

    # This is used in doit
    if {$recalc_flag != 0} {
	set recalc_flag 0
	port message "Monitor recalculation set to manual"
    } else {
	set recalc_flag 1
	port message "Monitor recalculation set to automatic"
    }
}

proc b4_fn {} {	# disconnect and exit
    # easy way to exit Tk applications.  tclXess cleans up properly
    destroy .
}


# First, we want to make sure that the window doesn't show up on
# the screen:
wm withdraw .

# Now we start things up.  The connect command creates the port
# object which is used to talk to Xess in the functions above.
if [catch {xess connect port -name SysMon -timeout 10 \
                -closecommand {
                   puts stderr "Port number %P closed; exiting...\n"
                   destroy .
                }}] {
    puts stderr "Couldn't connect after 10 seconds"
    destroy .
}

# create a menu, with a corresponding menu object
port menu monitor -name Monitor
# create menu buttons on the monitor menu.  These are also
# objects, though we won't be using them as such.
monitor button start -name "Start Monitor" -command b1_fn
monitor button stop -name "Stop Monitor" -command b2_fn
monitor button toggle -name "Toggle Recalc" -command b3_fn
monitor button disconnect -name "Disconnect" -command b4_fn

