#!/usr/local/bin/tclXess -f
#
# Copyright 1993, 1994 Applied Information Systems
# All rights reserved
#
# This example simulates a limited financial data feed.
# It returns four columns -- date, low, close, high
# It is meant to be used with the datafeed.xs3 spreadsheet.  Instructions
# for use are included in that spreadsheet.
#
# This is a rough translation of example33.c

set ROWS 30
set ALARM_RATE 5
set n 0
set count 0
set closing 50.0
set newclosing 0.0
set mon_row 0
set mon_col 0
set recalc_flag 1
set doingit 0

proc srand {seed} {
 global rand
 set rand(ia) 9301
 set rand(ic) 49297
 set rand(im) 233280
 set rand(seed) $seed
}
proc random {x} {
 global rand
 set rand(seed) [expr ($rand(seed)*$rand(ia) + $rand(ic)) % $rand(im)]
 expr $x * $rand(seed)/double($rand(im))
}
proc min {x y} { if {$x < $y} { return $x } else { return $y } }
proc max {x y} { if {$x > $y} { return $x } else { return $y } }

proc data {x} {
 global closing
 set y [expr double($x)]
 expr ($closing + [random 6.0] \
       * (sin($y * 0.28) + 1.3 * sin($y) - 0.3 * cos($y)) \
       + abs([random 0.3]))
}
proc low {x} {
 global newclosing
 min $newclosing [expr [data $x] - [random 3.5]]
}
proc high {x} {
 global newclosing
 max $newclosing [expr [data $x] + [random 3.5]]
}

proc doit {} {
 global count newclosing closing mon_row mon_col ROWS recalc_flag doingit ALARM_RATE

 # don't go if turned off
 if {$doingit == 0} { return }

 # scroll old numbers to make room for one new row
 port scroll_range \
      [xess encode_range {$mon_row $mon_col 00} \
                         {[expr $mon_row + $ROWS - 1] [expr $mon_col + 3] 00}] \
      -up

 # create and store new data values
 set newclosing [data $count]
 if {$newclosing < 30.0} {
  # don't let it get too low
  set newclosing [expr $newclosing * 1.25]
 } elseif {$newclosing > 90.0} {
  # if too high, two-for-one split
  set newclosing [expr $newclosing * 0.50]
 }
 port store [xess encode_cell [expr $mon_row + $ROWS - 1] \
                              $mon_col 00] $count
 incr count
 port store [xess encode_cell [expr $mon_row + $ROWS - 1] \
                              [expr $mon_col + 2] 00] $newclosing
 port store [xess encode_cell [expr $mon_row + $ROWS - 1] \
                              [expr $mon_col + 1] 00] \
            [min [low $count] $closing]
 port store [xess encode_cell [expr $mon_row + $ROWS - 1] \
                              [expr $mon_col + 3] 00] \
            [max [high $count] $closing]
 set closing $newclosing

 # force a recalculation if desired
 if {$recalc_flag} {
  port recalc -force \
              [xess encode_range {$mon_row $mon_col 00} \
                                 {[expr $mon_row + $ROWS] \
                                  [expr $mon_col + 3] 00}]
 }
 # syncronize with Xess
 port flush

 # do all this again in $ALARM_RATE seconds
 after [expr 1000 * $ALARM_RATE] doit
}

proc b1_fn {} {
 global count newclosing closing mon_row mon_col ROWS recalc_flag doingit ALARM_RATE

 # don't start up multiple times and really confuse things...
 if {$doingit == 1} { return }

 # current location of the cursor will be the base from which the
 # positions of the other cells are calculated
 set loc [port get_location]
 # transform the string returned from get_location into a list of
 # numbers that are easy to work with
 set dloc [xess decode_cell $loc]
 # now use lindex to dig the row and column numbers out
 set mon_row [lindex $dloc 0]
 set mon_col [lindex $dloc 1]

 port message "Starting Data Feed..."
 set count 34351
 for {set i 0} {$i < $ROWS} {incr i} {
  set newclosing [data $count]
  if {$newclosing < 30.0} {
   set newclosing [expr $newclosing * 1.25]
  } elseif {$newclosing > 90.0} {
   set newclosing [expr $newclosing * 0.50] # Two-for-one split
  }
  port store [xess encode_cell [expr $mon_row + $i] \
                               $mon_col 00] $count
  incr count
  port store [xess encode_cell [expr $mon_row + $i] \
                               [expr $mon_col + 2] 00] $newclosing
  port store [xess encode_cell [expr $mon_row + $i] \
                               [expr $mon_col + 1] 00] \
             [min [low $count] $closing]
  port store [xess encode_cell [expr $mon_row + $i] \
                               [expr $mon_col + 3] 00] \
             [max [high $count] $closing]
  set closing $newclosing
 }

 set doingit 1
 doit
}

proc b2_fn {} {    # Toggle recalculation flag
 if {recalc_flag} {
  set recalc_flag 0
  port message "Monitor recalculation set to manual"
 } else {
  set recalc_flag 1
  port message "Monitor recalculation set to automatic"
 }
}

proc b3_fn {} {    # disconnect and exit
 destroy .
}


# First, we want to make sure that the window doesn't show up on
# the screen:
wm withdraw .
 
# Now we start things up.  The connect command creates the port
# object which is used to talk to Xess in the functions above.
if [catch {xess connect port -name DataFeed -timeout 10 \
                -closecommand {
                   puts stderr "Port number %P closed; exiting...\n"
                   destroy .
                }}] {
   puts stderr "Couldn't connect after 10 seconds"
   destroy .
}

# initialize the random number generator
srand 1454564657

# create a menu, with a corresponding menu object
port menu monitor -name DataFeed
# create menu buttons on the monitor menu.  These are also
# objects, though we won't be using them as such.
monitor button start -name "Start Up" -command b1_fn
monitor button toggle -name "Toggle Recalc" -command b2_fn
monitor button disconnect -name "Disconnect" -command b3_fn
