#!/usr/local/bin/tclXess -f
#
# print .xs3 files, only bringing up an xess icon on the display while
# working.
# This script is simplistic and doesn't do much error checking,
# but it gets the job done pretty nicely.  If you want to use it
# in a production environment, add error checking -- this script
# is meant to demonstrate how a simple tclXess script can get
# a job done very easily.
#
# This is also one of the nice parts about Tcl; unhandled exceptions
# stop execution of the script, and you know that there is a problem
# even without explicit error checking in the script.

# We don't want a window:
wm withdraw .

# process command line arguments
if {( $argc < 1 )} then {
  puts stderr "Usage: $argv0 <filename>
       (where <filename> is the name of an Xess .xs3 file)"
  exit 1
}

set xesspid [exec xess3 -con a -iconic &]
xess connect con -name printxs
foreach file $argv {
  # print file
  con clear_sheet
  con read_file $file
  con print [con get_extent] -type ps
}

exec kill -HUP $xesspid

exit 0
