/*
 * $Id: tclXessInt.h,v 1.2 1994/11/14 20:49:36 johnsonm Exp $
 *
 * Copyright (c) 1992 General Electric.  All rights reserved.
 *
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: tclXessInt.h,v $
 * Revision 1.2  1994/11/14  20:49:36  johnsonm
 * Commented #endif comment.
 *
 * Revision 1.1  1994/08/26  14:35:02  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.4  1994/03/02  22:52:05  kennykb
 * Changed xessGetRow and xessGetColumn to used unsigned row and column
 * numbers.  The Xess connection library is inconsistent.
 *
 * Revision 1.3  1994/03/02  21:19:16  kennykb
 * Portability changes for autoconf.
 *
 * Revision 1.2  1994/02/28  20:34:30  kennykb
 * Added <stdlib.h> and <string.h> to the standard set of included files.
 * FIXME: This will have to be revised in autoconfig.
 *
 * Removed display and application main window from the XessConnection
 * structure, but added a Tk_UID that identifies the screen.  Display is now
 * managed in the Tk library by opening a dummy window on the display,
 * retrieving the display pointer from it, and closing the dummy window again.
 * This kludge has the side effect of establishing Tk event management ot
 * the display.
 *
 * Removed the XessDisplayOption parser and printer.  Display is parsed
 * now only by Tk_CreateWindow.
 *
 * Added a conditional declaration for `free', to avoid errors if stdlib.h
 * is broken (with `free' missing), and the only reference to `free' is in
 * the TCL_DYNAMIC macro expansion.
 *
 * Revision 1.1  1992/10/09  18:55:59  kennykb
 * Initial revision
 *
 *
 * tclXessInt.h --
 *
 *	This file contains definitions of all the internals needed in
 * the interface between Tcl and the XESS API.
 *
 */

#if STDC_HEADERS || HAVE_STDLIB_H
#include <stdlib.h>
#endif

/* We need to use somebody's string library. */

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>
/* An ANSI string.h and a pre-ANSI memory.h might conflict */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif
#else
#include <strings.h>
#define strchr index
#define strrchr rindex
#endif

#include <tcl.h>
#include <tk.h>
#include "genfunc.h"
#include "xess.h"
#ifndef NeedFunctionPrototypes
#include "xessfns.h"
#endif

/* Configuration parameters */

#define XESS_PORTS 64		/* Maximum number of Xess connection ports */

/* Data structure describing an Xess connection */

typedef struct XessConnection {
  Tcl_Interp * interp;		/* Interpreter in which connection was
				 * opened */
  char * objectName;		/* Name of the connection object command */
  Tk_Uid screenUid;		/* Name of the screen on which Xess is
				 * running */
  int dispID;			/* Xess internal identifier for the display */
  char * name;			/* Connection name */
  int port;			/* Xess port ID for the connection */
  int timeout;			/* Timeout for connection */
  Window window;		/* X window ID for the instance of Xess */
  char * closeCmd;		/* Close command */
  char * messageCmd;		/* Message command */
  struct XessMenu * firstMenu;	/* First menu in the spreadsheet */
  struct XessFunction * firstFunction;
				/* First external function installed in the */
				/* sheet. */
  int flags;			/* Set of flags for connection state */
} XessConnection;

/* Bits in the `flags' word above */

#define XESS_CONNECTION_CLOSED	(1<<0)
				/* Flag: connection closed at other end */
#define XESS_FUNCTION_PENDING	(1<<1)
				/* Flag: external function evaluation in */
				/* progress. */
#define XESS_CONNECTION_LOCKED	(1<<2)
				/* Flag: xess_user_lock has been set */

/* Table of active connections indexed by port */

extern XessConnection * XessConnTable [XESS_PORTS];

/* Data structure describing an Xess menu */

typedef struct XessMenu {
  XessConnection * conn;	/* Connection to which this menu belongs */
  long menuID;			/* XESS menu ID of this menu */
  char * objectName;		/* Name of the menu object command */
  char * name;			/* Name of the menu in menubar */
  struct XessButton * firstButton;
				/* First button in the menu */
  struct XessMenu * next, * prev;
				/* Next and previous menu in the spreadsheet */
} XessMenu;

/* Data structure describing an Xess menubutton */

typedef struct XessButton {
  XessMenu * menu;		/* Menu to which this button pertains */
  long buttonID;		/* XESS button ID of this button */
  char * objectName;		/* Name of the button object command */
  char * name;			/* Name of the button within the menu */
  char * command;		/* Command to execute when button pressed */
  struct XessButton * next, * prev;
				/* Next and previous button in the menu */
} XessButton;

/* Data structure describing an Xess external function */

typedef struct XessFunction {
  XessConnection * conn;	/* Connection to which this function belongs */
  char * name;			/* Name of the function within Xess */
  char * function;		/* Tcl function to execute when function is */
				/* invoked */
  struct XessFunction * next, * prev;
				/* Next and previous function */
} XessFunction;

/* Data structure describing an Xess cell */

typedef struct XessCell {
  int row;			/* Row number */
  int col;			/* Column number */
  int flags;			/* Flags */
} XessCell;

#define XESS_CELL_ABSROW (1<<0)	/* Absolute row address */
#define XESS_CELL_ABSCOL (1<<1)	/* Absolute column address */


#ifdef notdef
/* Tk option parser and printer for the `-display' option on commands */

extern TK_DECLARE_CUSTOM_PARSE( XessParseDisplay )
extern char * XessPrintDisplay _ANSI_ARGS_((ClientData, Tk_Window,
					    char *, int, Tcl_FreeProc **));

extern Tk_CustomOption XessDisplayOption;
#endif

/* The parser for Xess cell addresses */

extern int xessGetRange _ANSI_ARGS_((Tcl_Interp * interp, char * address,
				     Range * range));
extern TK_DECLARE_GENFUNC( xessGetRangeArgv )
extern int xessGetCell _ANSI_ARGS_((Tcl_Interp *, char *, XessCell *));
extern TK_DECLARE_GENFUNC( xessGetCellArgv )
extern int xessGetColumn _ANSI_ARGS_((Tcl_Interp * interp, char * colname,
				      int flags, unsigned * col,
				      int * retflags,
				      char ** next));
extern TK_DECLARE_GENFUNC( xessGetColumnArgv )
extern int xessGetRow _ANSI_ARGS_((Tcl_Interp * inter, char * rowname,
				   int flags, unsigned * row, int * retflags,
				   char ** next));
extern TK_DECLARE_GENFUNC( xessGetRowArgv )

/* Re-encode cell addresses */

extern int xessStoreRange _ANSI_ARGS_((Tcl_Interp * interp, Range * range,
				       char * rangestring, char * * next));
extern int xessStoreCell _ANSI_ARGS_((Tcl_Interp * interp, int row, int col,
				      int flags,
				      char * cellname, char * * next));
extern int xessStoreColumn _ANSI_ARGS_((Tcl_Interp * interp, int col,
					int flags,
					char * colname, char * * next));
extern int xessStoreRow _ANSI_ARGS_((Tcl_Interp * interp, int row, int flags,
				     char * rowname, char * * next));

/* The parser for Xess font IDs */

extern int xessGetFont _ANSI_ARGS_((Tcl_Interp *, char *, int *));
extern TK_DECLARE_GENFUNC( xessGetFontArgv )

/* The parser for Xess format codes */

extern int xessGetFormat _ANSI_ARGS_((Tcl_Interp *, char *, int *));
extern TK_DECLARE_GENFUNC( xessGetFormatArgv )

/* The parser for Xess print types */

extern int xessGetPrinttype _ANSI_ARGS_((Tcl_Interp *, char *, int *));
extern TK_DECLARE_GENFUNC( xessGetPrinttypeArgv )

/* The parser for Xess file types */

extern int xessGetFiletype _ANSI_ARGS_((Tcl_Interp *, char *, int *));
extern TK_DECLARE_GENFUNC( xessGetFiletypeArgv )

/* Tk_ConfigureWidget custom option procedures for flagging whether an
 * option is present. */

extern TK_DECLARE_CUSTOM_PARSE( xessOptionFlagParseProc )
extern int xessOptionFlagParseProc _ANSI_ARGS_((ClientData, Tcl_Interp *,
						Tk_Window, char *, char *,
						int));
extern char * xessOptionFlagPrintProc _ANSI_ARGS_((ClientData, Tk_Window,
						   char *, int,
						   Tcl_FreeProc * *));

#define XESS_OPTION_BIT(name,value)					\
static Tk_CustomOption name = {						\
  xessOptionFlagParseProc,						\
  xessOptionFlagPrintProc,						\
  (ClientData) value							\
}

#define XESS_OPTION_FLAG(widget,word,bit)				\
  { TK_CONFIG_CUSTOM, (char *) NULL, (char *) NULL, (char *) NULL,	\
    (char *) NULL, Tk_Offset(widget,word), 0, &bit }

/* Callback for Xess event processing */

extern Bool XessEventFilter _ANSI_ARGS_((ClientData, XEvent *));

/* Xess callback entries */

extern void XessCloseCallback _ANSI_ARGS_((int port));
extern void XessReceiveCallback _ANSI_ARGS_((int port, char message[15]));

/* Procedure to execute a Tcl callback from Xess */

extern int XessEvalCallback _ANSI_ARGS_((XessConnection *,
					 Tcl_Interp *,
					 char *,
					 char *));
extern XessButton * XessCallbackButton;
				/* Button that caused a callback to be
				   invoked */
extern char * XessCallbackMessage;
				/* Interclient message to be reported */

/* Tcl object commands */

extern int XessConnObj_cmd _ANSI_ARGS_((ClientData, Tcl_Interp *,
					int, char * *));

/* External cleanup entries needed for shutting things down gracefully */

extern void XessConnObj_Destroy _ANSI_ARGS_((ClientData));
				/* Destroy a connection object */
extern void XessFunctObj_Delete _ANSI_ARGS_((struct XessFunction *));
				/* Destroy an external function binding */
extern void XessMenuObj_Delete _ANSI_ARGS_((struct XessMenu *));
				/* Destroy a menu object. */
extern void XessDialogCleanup _ANSI_ARGS_((XessConnection *));
				/* Clean up dialog box associated with a */
				/* connection */

#ifdef FREEBUG
/* TCL_DYNAMIC doesn't function unless a declaration of `free' is present
 * somewhere...
 */

extern void free _ANSI_ARGS_((char *));
#endif /* FREEBUG */

