char RCSid_xessCODestroy_c []
= "$Id: xessCODestroy.c,v 1.1 1994/08/26 13:15:34 johnsonm Exp $";
static char copyright []
= "$Id: xessCODestroy.c,v 1.1 1994/08/26 13:15:34 johnsonm Exp $\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCODestroy.c,v $
 * Revision 1.1  1994/08/26  13:15:34  johnsonm
 * Initial revision
 *
 * Revision 1.2  1994/02/28  20:41:05  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:00:10  kennykb
 * Initial revision
 *
 *
 * xessCODestroy.c --
 *
 *	Function to destroy an Xess connection.  Invoked when the connection
 * object is destroyed, when the conneciton is reported closed at the other
 * end, or when the user executes a `close' operation on the connection
 * object.
 */


#include "tclXessInt.h"

/*
 * XessConnObj_Destroy --
 *
 *	This function destroys an Xess connection object when the connection
 * is shut down for any reason.  It calls the Xess connection library to close
 * the connection (unless this has already been done), and frees all memory
 * associated with the connection object.  Note that the connection object
 * command has already been deleted by the time we get here, since this
 * function is invoked as a result of the `destroy command' callback from
 * the Tcl interpreter.
 */

void
XessConnObj_Destroy (clientData)
     ClientData clientData;
{
  XessConnection * conn = (XessConnection *) clientData;

  /* Delete any menus still open at this connection */

  while (conn -> firstMenu)
    XessMenuObj_Delete (conn -> firstMenu);
  while (conn -> firstFunction)
    XessFunctObj_Delete (conn -> firstFunction);

  /* Clean up any dialog box associated with this connection */

  XessDialogCleanup (conn);

  /* Tell the connection library to close the object if it isn't
   * closed already */

  if (!(conn -> flags & XESS_CONNECTION_CLOSED)) {
    if (conn -> flags & XESS_CONNECTION_LOCKED) {
      xess_user_lock (conn -> port, 0);
    }
    xess_close_connection (conn -> port);
  }

  /* Remove the connection object from the connection table */

  XessConnTable [conn -> port] = (XessConnection *) NULL;

  /* Free up memory allocated for the object */

  (void) ckfree (conn -> objectName);
  (void) ckfree (conn -> name);
  if (conn -> closeCmd)
    (void) ckfree (conn -> closeCmd);
  if (conn -> messageCmd)
    (void) ckfree (conn -> messageCmd);
  (void) ckfree (conn);

}

