static char copyright []
= "$Id: xessCOEvent.c,v 1.1 1994/08/26 13:19:47 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCOEvent.c,v $
 * Revision 1.1  1994/08/26  13:19:47  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:41:32  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:00:39  kennykb
 * Initial revision
 *
 *
 * xessCOEvent.c --
 *
 *	This file contains the source code for the `X Event Handling'
 *	operations that apply directly to an Xess connection object.  There
 *	are only two of these -- `user_lock' and `flush'
 */

#include "tclXessInt.h"


/*
 * XessConnObj_user_lock_cmd --
 *
 *	This procedure handles the `user_lock' command on an Xess connection
 *	object.
 *
 * Syntax:
 *	connection user_lock value
 *
 * Where:
 *	connection is an Xess connection object
 *	value is a Boolean value.  True means lock interactions, and False
 *		means unlock interactions.
 *
 * Result:
 *	Returns a standard Tcl result, normally empty.
 */

int
XessConnObj_user_lock_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  int value;
  int status;

  /* Check syntax */

  if (argc != 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], " value\"", (char *) NULL);
    return TCL_ERROR;
  }
  status = Tcl_GetBoolean (interp, argv [1], &value);
  if (status != TCL_OK)
    return status;

  /* Lock or unlock the sheet */

  xess_user_lock (conn -> port, value);
  if (value) {
    conn -> flags |= XESS_CONNECTION_LOCKED;
  } else {
    conn -> flags &= ~ XESS_CONNECTION_LOCKED;
  }

  return TCL_OK;
}

/*
 * XessConnObj_flush_cmd --
 *
 *	This procedure handles the `flush' command on an Xess connection
 *	object.
 *
 * Syntax:
 *	connection flush
 *
 * Where:
 *	connection is an Xess connection object
 *
 * Result:
 *	Returns a standard Tcl result, normally empty.
 */

int
XessConnObj_flush_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;
  int value;
  int status;

  /* Check syntax */

  if (argc != 1) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1], " ",
		      argv [0], "\"", (char *) NULL);
    return TCL_ERROR;
  }

  /* Lock or unlock the sheet */

  xess_flush_port (conn -> port);
  return TCL_OK;
}
