static char copyright []
= "$Id: xessCOMessage.c,v 1.1 1994/08/26 13:28:35 johnsonm Exp $\n\
   Copyright (c) 1992 General Electric.  All rights reserved.";

/*
 *   Permission to use, copy, modify, and distribute this
 *   software and its documentation for any purpose and without
 *   fee is hereby granted, provided that the above copyright
 *   notice appear in all copies and that both that copyright
 *   notice and this permission notice appear in supporting
 *   documentation, and that the name of General Electric not be used in
 *   advertising or publicity pertaining to distribution of the
 *   software without specific, written prior permission.
 *   General Electric makes no representations about the suitability of
 *   this software for any purpose.  It is provided "as is"
 *   without express or implied warranty.
 *
 *   This work was supported by the DARPA Initiative in Concurrent
 *   Engineering (DICE) through DARPA Contract MDA972-88-C-0047.
 *
 * $Log: xessCOMessage.c,v $
 * Revision 1.1  1994/08/26  13:28:35  johnsonm
 * Initial revision
 *
 *
 * Old log:
 * Revision 1.2  1994/02/28  20:42:23  kennykb
 * Removed #includes that are now obtained from tclXessInt.h
 *
 * Revision 1.1  1992/10/09  19:01:39  kennykb
 * Initial revision
 *
 *
 * xessCOMessageCmd.c --
 * 
 *	Handle the `message' command on an Xess connection object
 */

#include "tclXessInt.h"

/*
 * XessConnObj_message_cmd --
 *
 *	Handle the `message' command on an Xess connection object
 *
 * Syntax:
 *
 *	connectionName message text
 *
 * Where:
 *	connectionName is the name of an Xess connection object.
 *	text is the text of the message to display
 *
 * Results:
 *	Returns a standard Tcl result.
 */

int
XessConnObj_message_cmd (clientData, interp, argc, argv)
     ClientData clientData;
     Tcl_Interp * interp;
     int argc;
     char * * argv;
{
  XessConnection * conn = (XessConnection *) clientData;

  char * message;

  if (argc < 2) {
    Tcl_AppendResult (interp, "wrong # args, should be \"", argv [-1],
		      " ", argv [0], " text\"", (char *) NULL);
    return TCL_ERROR;
  }

  message = Tcl_Concat (argc-1, argv+1);

  xess_display_message (conn -> port, message);

  (void) ckfree (message);

  return TCL_OK;
}
